/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import java.util.HashMap;
import java.util.Map;

public class ResourceFixtureFactory
implements FixtureFactory<Resource> {
    private final FixtureLoader fixtureLoader;

    public ResourceFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<Resource> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new ResourceFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class ResourceFixtures
    extends DefaultFixtures<Resource>
    implements Fixtures<Resource> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Resource>> resourceMap;

        public ResourceFixtures(String fixtureName, Map<String, Map<String, String>> values, FixtureLoader fixtureLoader) {
            super(Resource.class, values, fixtureLoader);
            this.resourceMap = new HashMap<String, Fixture<Resource>>();
            this.entries = values;
        }

        @Override
        public Fixture<Resource> getEntry(String entryName) throws OXException {
            if (this.resourceMap.containsKey(entryName)) {
                return this.resourceMap.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            Resource resource = new Resource();
            this.apply(resource, values);
            Fixture<Resource> fixture = new Fixture<Resource>(resource, values.keySet().toArray(new String[values.size()]), values);
            this.resourceMap.put(entryName, fixture);
            return fixture;
        }
    }
}

