/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.RootRequest;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.folder.actions.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonAllRequest;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.CommonUpdatesResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.TestManager;
import com.openexchange.tools.arrays.Arrays;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class FolderTestManager
implements TestManager {
    private AbstractAJAXResponse lastResponse;
    private List<FolderObject> createdItems;
    private final AJAXClient client;
    private boolean failOnError = true;
    private boolean ignoreMailFolders = true;
    private Throwable lastException;

    @Override
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean getFailOnError() {
        return this.failOnError;
    }

    public boolean getIgnoreMailFolders() {
        return this.ignoreMailFolders;
    }

    public void setIgnoreMailFolders(boolean ignoreMailFolders) {
        this.ignoreMailFolders = ignoreMailFolders;
    }

    public void setLastResponse(AbstractAJAXResponse lastResponse) {
        this.lastResponse = lastResponse;
    }

    @Override
    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    public FolderTestManager(AJAXClient client) {
        this.client = client;
        this.createdItems = new LinkedList<FolderObject>();
    }

    public FolderObject insertFolderOnServer(FolderObject folderToCreate) {
        InsertRequest request = new InsertRequest((API)EnumAPI.OX_OLD, folderToCreate);
        CommonInsertResponse response = null;
        try {
            response = this.client.execute(request);
            this.setLastResponse(response);
            response.fillObject((DataObject)folderToCreate);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "NewRequest");
        }
        this.createdItems.add(folderToCreate);
        return folderToCreate;
    }

    public void insertFoldersOnServer(FolderObject[] folders) {
        for (FolderObject folder : folders) {
            this.insertFolderOnServer(folder);
        }
    }

    public FolderObject updateFolderOnServer(FolderObject folder) {
        return this.updateFolderOnServer(folder, true);
    }

    public FolderObject updateFolderOnServer(FolderObject folder, boolean failOnError) {
        UpdateRequest request = new UpdateRequest((API)EnumAPI.OX_OLD, folder, failOnError);
        try {
            this.setLastResponse(this.client.execute(request));
            this.remember(folder);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "UpdateRequest");
        }
        return folder;
    }

    public void deleteFolderOnServer(FolderObject folderToDelete) throws OXException, IOException, SAXException, JSONException {
        this.deleteFolderOnServer(folderToDelete, Boolean.FALSE);
    }

    public void deleteFolderOnServer(FolderObject folderToDelete, Boolean hardDelete) throws OXException, IOException, SAXException, JSONException {
        DeleteRequest request = new DeleteRequest((API)EnumAPI.OX_OLD, folderToDelete);
        request.setHardDelete(hardDelete);
        this.setLastResponse(this.client.execute(request));
        if (hardDelete.booleanValue()) {
            this.removeFolderFromCleanupList(folderToDelete);
        }
    }

    public void deleteFolderOnServer(int folderID, Date lastModified) throws OXException, IOException, SAXException, JSONException {
        FolderObject fo = new FolderObject();
        fo.setObjectID(folderID);
        fo.setLastModified(lastModified);
        this.deleteFolderOnServer(fo);
    }

    private void removeFolderFromCleanupList(FolderObject folderToDelete) {
        Iterator<FolderObject> it = this.createdItems.iterator();
        while (it.hasNext()) {
            FolderObject folder = it.next();
            if (folder.getObjectID() == folderToDelete.getObjectID() && !folder.containsFullName() && !folderToDelete.containsFullName()) {
                it.remove();
            }
            if (!folder.containsFullName() || !folderToDelete.containsFullName() || folder.containsObjectID() || folderToDelete.containsObjectID() || !folder.getFullName().equals(folderToDelete.getFullName())) continue;
            it.remove();
        }
    }

    public FolderObject getFolderFromServer(FolderObject folder) {
        if (folder.getObjectID() == 0) {
            return this.getFolderFromServer(folder.getFullName(), this.getFailOnError());
        }
        return this.getFolderFromServer(folder.getObjectID(), this.getFailOnError());
    }

    public FolderObject getFolderFromServer(FolderObject folder, boolean failOnErrorOverride) {
        if (folder.getObjectID() == 0) {
            return this.getFolderFromServer(folder.getFullName(), failOnErrorOverride);
        }
        return this.getFolderFromServer(folder.getObjectID(), failOnErrorOverride);
    }

    public FolderObject getFolderFromServer(int folderID, boolean failOnErrorOverride, int[] additionalColumns) {
        boolean oldValue = this.getFailOnError();
        this.setFailOnError(failOnErrorOverride);
        FolderObject returnedFolder = null;
        GetRequest request = new GetRequest((API)EnumAPI.OX_OLD, folderID, Arrays.addUniquely((int[])FolderObject.ALL_COLUMNS, (int[])additionalColumns));
        GetResponse response = null;
        try {
            response = this.client.execute(request);
            this.setLastResponse(response);
            returnedFolder = response.getFolder();
            this.setFailOnError(oldValue);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "GetRequest for folder with id " + folderID);
        }
        return returnedFolder;
    }

    public FolderObject getFolderFromServer(String name) {
        return this.getFolderFromServer(name, this.getFailOnError());
    }

    public FolderObject getFolderFromServer(String name, boolean failOnErrorOverride) {
        FolderObject returnedFolder = null;
        GetRequest request = new GetRequest((API)EnumAPI.OX_OLD, name, failOnErrorOverride);
        GetResponse response = null;
        try {
            response = this.client.execute(request);
            this.setLastResponse(response);
            returnedFolder = response.getFolder();
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "GetRequest");
        }
        return returnedFolder;
    }

    public FolderObject getFolderFromServer(int folderId, boolean failOnErrorOverride) {
        return this.getFolderByStringFromServer(Integer.toString(folderId), failOnErrorOverride);
    }

    public FolderObject getFolderByStringFromServer(String folderId, boolean failOnErrorOverride) {
        boolean oldValue = this.getFailOnError();
        this.setFailOnError(failOnErrorOverride);
        FolderObject returnedFolder = null;
        GetRequest request = new GetRequest((API)EnumAPI.OX_OLD, folderId, FolderObject.ALL_COLUMNS);
        GetResponse response = null;
        try {
            response = this.client.execute(request);
            this.setLastResponse(response);
            returnedFolder = response.getFolder();
            this.setFailOnError(oldValue);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "GetRequest for folder with id " + folderId);
        }
        return returnedFolder;
    }

    public FolderObject getFolderFromServer(int folderId) {
        return this.getFolderFromServer(folderId, this.getFailOnError());
    }

    @Override
    public void cleanUp() {
        Vector<FolderObject> deleteMe = new Vector<FolderObject>(this.createdItems);
        try {
            for (FolderObject folder : deleteMe) {
                folder.setLastModified(new Date(Long.MAX_VALUE));
                this.deleteFolderOnServer(folder, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "clean-up");
        }
        this.createdItems = new LinkedList<FolderObject>();
    }

    public FolderObject[] listFoldersOnServer(int parentFolderId) {
        return this.listFoldersOnServer(parentFolderId, null);
    }

    public FolderObject[] listFoldersOnServer(int parentFolderId, int[] additionalFields) {
        Vector<FolderObject> allFolders = new Vector<FolderObject>();
        ListRequest request = new ListRequest((API)EnumAPI.OX_OLD, Integer.toString(parentFolderId), Arrays.addUniquely((int[])new int[]{1}, (int[])additionalFields), this.getFailOnError());
        try {
            ListResponse response = this.client.execute(request);
            Iterator<FolderObject> iterator = response.getFolder();
            while (iterator.hasNext()) {
                allFolders.add(iterator.next());
            }
            this.setLastResponse(response);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "ListRequest");
        }
        Object[] folderArray = new FolderObject[allFolders.size()];
        allFolders.copyInto(folderArray);
        return folderArray;
    }

    public FolderObject[] listFoldersOnServer(FolderObject folder) {
        if (folder.getObjectID() != 0) {
            return this.listFoldersOnServer(folder.getObjectID());
        }
        Vector<FolderObject> allFolders = new Vector<FolderObject>();
        ListRequest request = new ListRequest((API)EnumAPI.OX_OLD, folder.getFullName(), new int[]{1}, this.getFailOnError());
        try {
            ListResponse response = this.client.execute(request);
            this.setLastResponse(response);
            Iterator<FolderObject> iterator = response.getFolder();
            while (iterator.hasNext()) {
                allFolders.add(iterator.next());
            }
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "ListRequest");
        }
        Object[] folderArray = new FolderObject[allFolders.size()];
        allFolders.copyInto(folderArray);
        return folderArray;
    }

    public FolderObject[] listRootFoldersOnServer() {
        Vector<FolderObject> allFolders = new Vector<FolderObject>();
        RootRequest request = new RootRequest(EnumAPI.OX_OLD, new int[]{1}, this.ignoreMailFolders);
        try {
            ListResponse response = this.client.execute(request);
            this.setLastResponse(response);
            Iterator<FolderObject> iterator = response.getFolder();
            while (iterator.hasNext()) {
                allFolders.add(iterator.next());
            }
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "ListRequest for root folders");
        }
        Object[] folderArray = new FolderObject[allFolders.size()];
        allFolders.copyInto(folderArray);
        return folderArray;
    }

    public FolderObject[] getUpdatedFoldersOnServer(Date lastModified) {
        return this.getUpdatedFoldersOnServer(lastModified, null);
    }

    public FolderObject[] getUpdatedFoldersOnServer(Date lastModified, int[] additionalFields) {
        Vector<FolderObject> allFolders = new Vector<FolderObject>();
        UpdatesRequest request = new UpdatesRequest(EnumAPI.OX_OLD, Arrays.addUniquely((int[])new int[]{1}, (int[])additionalFields), -1, null, lastModified);
        try {
            CommonUpdatesResponse response = this.client.execute(request);
            int idPos = this.findIDPosition(response.getColumns());
            JSONArray data = (JSONArray)response.getResponse().getData();
            FolderObject fo = new FolderObject();
            for (int i = 0; i < data.length(); ++i) {
                JSONArray tempArray = data.getJSONArray(i);
                fo = this.getFolderByStringFromServer(tempArray.getString(idPos), this.getFailOnError());
                allFolders.add(fo);
            }
            this.setLastResponse(response);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "AllRequest");
        }
        Object[] folderArray = new FolderObject[allFolders.size()];
        allFolders.copyInto(folderArray);
        return folderArray;
    }

    private int findPositionOfColumn(int[] haystack, int needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    private int findIDPosition(int[] columns) {
        return this.findPositionOfColumn(columns, 1);
    }

    private void remember(FolderObject folder) {
        for (FolderObject tempFolder : this.createdItems) {
            if (tempFolder.getObjectID() == folder.getObjectID()) {
                this.createdItems.set(this.createdItems.indexOf(tempFolder), folder);
                continue;
            }
            this.createdItems.add(folder);
        }
    }

    public FolderObject[] getAllFoldersOnServer(int folderId) {
        Vector<FolderObject> allFolders = new Vector<FolderObject>();
        CommonAllRequest request = new CommonAllRequest("/ajax/folders", folderId, new int[]{1}, 0, null, this.getFailOnError());
        try {
            CommonAllResponse response = this.client.execute(request);
            JSONArray data = (JSONArray)response.getResponse().getData();
            for (int i = 0; i < data.length(); ++i) {
                JSONArray temp = data.optJSONArray(i);
                int tempFolderId = temp.getInt(0);
                FolderObject tempFolder = this.getFolderFromServer(tempFolderId);
                allFolders.add(tempFolder);
            }
            this.setLastResponse(response);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "AllRequest");
        }
        Object[] folderArray = new FolderObject[allFolders.size()];
        allFolders.copyInto(folderArray);
        return folderArray;
    }

    protected void doExceptionHandling(Exception exception, String action) {
        try {
            this.lastException = exception;
            throw exception;
        }
        catch (OXException e) {
            if (this.getFailOnError()) {
                Assert.fail((String)("AjaxException occured during " + action + ": " + e.getMessage()));
            }
        }
        catch (IOException e) {
            if (this.getFailOnError()) {
                Assert.fail((String)("IOException occured during " + action + ": " + e.getMessage()));
            }
        }
        catch (SAXException e) {
            if (this.getFailOnError()) {
                Assert.fail((String)("SAXException occured during " + action + ": " + e.getMessage()));
            }
        }
        catch (JSONException e) {
            if (this.getFailOnError()) {
                Assert.fail((String)("JSONException occured during " + action + ": " + e.getMessage()));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected error occured during " + action + ": " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    public FolderObject generatePrivateFolder(String name, int moduleID, int parentID, int userID) {
        FolderObject folder = new FolderObject();
        folder.setFolderName(name);
        folder.setType(1);
        folder.setParentFolderID(parentID);
        folder.setModule(moduleID);
        OCLPermission permissions = new OCLPermission();
        permissions.setEntity(userID);
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(true);
        permissions.setAllPermission(128, 128, 128, 128);
        folder.addPermission(permissions);
        return folder;
    }

    public FolderObject generatePublicFolder(String name, int moduleID, int parentID, int ... userIDs) {
        FolderObject folder = new FolderObject();
        folder.setFolderName(name);
        folder.setType(2);
        folder.setParentFolderID(parentID);
        folder.setModule(moduleID);
        ArrayList<OCLPermission> allPermissions = new ArrayList<OCLPermission>();
        for (int userID : userIDs) {
            OCLPermission permissions = new OCLPermission();
            permissions.setEntity(userID);
            permissions.setGroupPermission(false);
            permissions.setFolderAdmin(true);
            permissions.setAllPermission(128, 128, 128, 128);
            allPermissions.add(permissions);
        }
        folder.setPermissions(allPermissions);
        return folder;
    }

    public FolderObject generateSharedFolder(String name, int moduleID, int parentID, int ... userIDs) {
        FolderObject folder = new FolderObject();
        folder.setFolderName(name);
        folder.setType(3);
        folder.setParentFolderID(parentID);
        folder.setModule(moduleID);
        ArrayList<OCLPermission> allPermissions = new ArrayList<OCLPermission>();
        boolean firstUser = true;
        for (int userID : userIDs) {
            OCLPermission permissions = new OCLPermission();
            permissions.setEntity(userID);
            permissions.setGroupPermission(false);
            permissions.setFolderAdmin(firstUser);
            permissions.setAllPermission(128, 128, 128, 128);
            allPermissions.add(permissions);
            firstUser = false;
        }
        folder.setPermissions(allPermissions);
        return folder;
    }

    @Override
    public boolean doesFailOnError() {
        return this.getFailOnError();
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public boolean hasLastException() {
        return this.lastException != null;
    }
}

