/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.groupware.Init;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.PoolRunner;
import com.openexchange.test.AjaxInit;
import java.util.Properties;
import junit.framework.TestCase;

public class ComplexDBPoolTest
extends TestCase {
    private static final int contextid = 1;
    private int userid;
    private final int TEST_RUNS = 50;
    private static int checksize = 0;
    private static int poolsize = 0;
    private static int totalcount = 0;

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"user_participant2", (String)"");
    }

    protected void tearDown() throws Exception {
        Init.stopServer();
        super.tearDown();
    }

    protected Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    private int resolveUser(String user) throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        this.userid = uStorage.getUserId(user, (Context)new ContextImpl(1));
        return this.userid;
    }

    public void testThreadedPool() throws Throwable {
        int a;
        ContextImpl context = new ContextImpl(1);
        checksize = poolsize;
        PoolRunner[] pr = new PoolRunner[50];
        for (a = 0; a < 50; ++a) {
            pr[a] = new PoolRunner((Context)context, false);
        }
        for (a = 0; a < 50; ++a) {
            pr[a].getRunnerThread().join();
        }
    }

    public void testThreadedPoolWithClosedConnections() throws Throwable {
        int a;
        ContextImpl context = new ContextImpl(1);
        checksize = poolsize;
        PoolRunner[] pr = new PoolRunner[50];
        for (a = 0; a < 50; ++a) {
            pr[a] = new PoolRunner((Context)context, false);
        }
        for (a = 0; a < 50; ++a) {
            pr[a].getRunnerThread().join();
        }
        System.err.println("Total runs : " + totalcount);
    }
}

