/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class MailMultipartAlternativeStructureTest
extends AbstractMailTest {
    private static final byte[] MP_ALTERNATIVE = "Date: Sat, 14 Nov 2009 17:03:09 +0100 (CET)\nFrom: alice@foobar.com\nTo: bob@foobar.com\nMessage-ID: <1837640730.5.1258214590077.JavaMail.foobar@foobar>\nSubject: The mail subject\nMIME-Version: 1.0\nContent-Type: multipart/alternative; \n    boundary=\"----=_Part_4_2138910064.1258214589840\"\nX-Priority: 3\n\n------=_Part_4_2138910064.1258214589840\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nMail text.\n\nPeople have been asking for support for the IMAP IDLE command for quite\na few years and I think I've finally figured out how to provide such\nsupport safely. The difficulty isn't in executing the command, which\nis quite straightforward, the difficulty is in deciding how to expose\nit to applications, and inhandling the multithreading issues that\narise.\n\n------=_Part_4_2138910064.1258214589840\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\" />\n    <title></title>\n  </head>\n\n  <body>\n    Mail text.<br />\n    <br />\n    People have been asking for support for the IMAP IDLE command for quite<br />\n    a few years and I think I&#39;ve finally figured out how to provide such<br />\n    support safely. The difficulty isn&#39;t in executing the command, which<br />\n    is quite straightforward, the difficulty is in deciding how to expose<br />\n    it to applications, and inhandling the multithreading issues that<br />\n    arise.<br />\n    <br />\n  </body>\n</html>\n\n------=_Part_4_2138910064.1258214589840--".getBytes();

    public MailMultipartAlternativeStructureTest() {
    }

    public MailMultipartAlternativeStructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])MP_ALTERNATIVE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailMultipartAlternativeStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailMultipartAlternativeStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailMultipartAlternativeStructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray bodyArray = (JSONArray)bodyObject;
            int length = bodyArray.length();
            MailMultipartAlternativeStructureTest.assertEquals((String)"Expected two body parts.", (int)2, (int)length);
            for (int i = 0; i < length; ++i) {
                JSONObject bodyPartObject = bodyArray.getJSONObject(i);
                JSONObject contentType = bodyPartObject.getJSONObject("headers").getJSONObject("content-type");
                if (0 == i) {
                    MailMultipartAlternativeStructureTest.assertTrue((String)"First body part is not plain text.", (boolean)contentType.getString("type").startsWith("text/plain"));
                    continue;
                }
                MailMultipartAlternativeStructureTest.assertTrue((String)"Second body part is not HTML.", (boolean)contentType.getString("type").startsWith("text/htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailMultipartAlternativeStructureTest.fail((String)e.getMessage());
        }
    }
}

