/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.replyforward;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Charsets;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;

public final class MailForwardTest
extends AbstractMailTest {
    private static final String RFC822_SRC = "Date: Wed, 2 Apr 2008 07:41:24 +0200 (CEST)\nFrom: \"Kraft, Manuel\" <manuel.kraft@open-xchange.com>\nTo: \"Betten, Thorben\" <thorben.betten@open-xchange.com>\nMessage-ID: <32481287.4641207114884399.JavaMail.open-xchange@oxee>\nSubject: Hello\nMIME-Version: 1.0\nContent-Type: multipart/mixed; \n\tboundary=\"----=_Part_298_27959028.1207114884271\"\nX-Priority: 3\nX-Mailer: OX Software GmbH;Development\n\n------=_Part_298_27959028.1207114884271\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nHello... This is the first message\n------=_Part_298_27959028.1207114884271\nMIME-Version: 1.0\nContent-Type: text/vcard; charset=UTF-8; name=my.vcf\nContent-Transfer-Encoding: quoted-printable\nContent-Disposition: attachment; filename=my.vcf\n\nBEGIN:VCARD\nVERSION:3.0\nEMAIL;TYPE=3Dwork,pref:thorben.betten@open-xchange.com\nFN:Thorben Betten\nIMPP;TYPE=3Dwork,pref:x-apple:th0rb3nb\nORG:Open-Xchange GmbH;Engineering\nPRODID:-//Open-Xchange//7.8.1-Rev5//EN\nX-OX-ROOM-NUMBER:Development 3\nREV:20160307T151919Z\nROLE:Software-Entwickler\nN:Betten;Thorben;;;\nTITLE:Leader Engineering\nEND:VCARD\n\n------=_Part_298_27959028.1207114884271--\n\n";
    private static final String RFC822_FORWARD = "Date: Mon, 31 Mar 2008 22:39:25 +0200\nTo: \"dream-team@open-xchange.com\" <dream-team@open-xchange.com>\nFrom: jane.doe@open-xchange.com\nOrganization: http://open-xchange.com/\nContent-Type: text/plain; charset=utf-8\nMIME-Version: 1.0\nMessage-ID: <op.t8webzmnraenw4@edna>\nUser-Agent: Opera Mail/9.26 (Linux)\nSubject: [dream-team] Good bye und macht's gut\nContent-Transfer-Encoding: 7bit\n\nHallo Dream-Team,\n\nThis is the second message\n";

    public MailForwardTest() {
    }

    public MailForwardTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailForward() {
        try {
            MailMessage sourceMail = MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII));
            ContextImpl ctx = new ContextImpl(this.getCid());
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                MailMessage forwardMail = mailAccess.getLogicTools().getFowardMessage(new MailMessage[]{sourceMail}, false);
                UserSettingMail usm = UserSettingMailStorage.getInstance().getUserSettingMail(this.getUser(), ctx.getContextId());
                MailForwardTest.assertTrue((String)"Header 'From' does not carry expected value", (boolean)forwardMail.getFrom()[0].equals((Object)new InternetAddress(usm.getSendAddr(), true)));
                User user = UserStorage.getStorageUser((int)session.getUserId(), (Context)ctx);
                Locale locale = user.getLocale();
                TimeZone tz = TimeZone.getTimeZone(user.getTimeZone());
                StringHelper stringHelper = StringHelper.valueOf((Locale)locale);
                String subjectPrefix = "Fwd: ";
                String subject = new StringBuilder(32).append("Fwd: ").append(sourceMail.getSubject()).toString();
                MailForwardTest.assertTrue((String)"Header 'Subject' does not carry expected value", (boolean)subject.equals(forwardMail.getSubject()));
                MailForwardTest.assertTrue((String)"Header 'Content-Type' does not carry expected value", (boolean)forwardMail.getContentType().isMimeType("multipart/mixed"));
                int count = forwardMail.getEnclosedCount();
                MailForwardTest.assertTrue((String)"Unexpected number of enclosed parts", (count == 2 ? 1 : 0) != 0);
                for (int i = 0; i < count; ++i) {
                    MailPart part = forwardMail.getEnclosedMailPart(i);
                    if (i == 0) {
                        MailForwardTest.assertTrue((String)"Unexpected content type in body", (boolean)part.getContentType().isMimeType("text/*"));
                        Object content = part.getContent();
                        MailForwardTest.assertTrue((String)"Missing content", (content != null ? 1 : 0) != 0);
                        if (!UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), (Context)ctx).isForwardAsAttachment()) {
                            String forwardPrefix = stringHelper.getString("---------- Original Message ----------\nFrom: #FROM#\nTo: #TO##CC_LINE#\nDate: #DATE# at #TIME#\nSubject: #SUBJECT#");
                            InternetAddress[] from = sourceMail.getFrom();
                            forwardPrefix = forwardPrefix.replaceFirst("#FROM#", from == null || from.length == 0 ? "" : from[0].toUnicodeString());
                            InternetAddress[] to = sourceMail.getTo();
                            forwardPrefix = forwardPrefix.replaceFirst("#TO#", to == null || to.length == 0 ? "" : MailForwardTest.addrs2String(to));
                            InternetAddress[] cc = sourceMail.getCc();
                            forwardPrefix = forwardPrefix.replaceFirst("#CC_LINE#", cc == null || cc.length == 0 ? "" : new StringBuilder(64).append("\nCc: ").append(MailForwardTest.addrs2String(cc)).toString());
                            Date date = sourceMail.getSentDate();
                            if (date == null) {
                                forwardPrefix = forwardPrefix.replaceFirst("#DATE#", "");
                                forwardPrefix = forwardPrefix.replaceFirst("#TIME#", "");
                            } else {
                                DateFormat dateFormat = DateFormat.getDateInstance(1, locale);
                                dateFormat.setTimeZone(tz);
                                forwardPrefix = forwardPrefix.replaceFirst("#DATE#", dateFormat.format(date));
                                dateFormat = DateFormat.getTimeInstance(3, locale);
                                dateFormat.setTimeZone(tz);
                                forwardPrefix = forwardPrefix.replaceFirst("#TIME#", dateFormat.format(date));
                            }
                            forwardPrefix = forwardPrefix.replaceFirst("#SUBJECT#", sourceMail.getSubject());
                            String text = content.toString().replaceAll("(\r?\n)> ", "$1");
                            MailForwardTest.assertTrue((String)("Missing forward prefix:\n" + forwardPrefix), (text.indexOf(forwardPrefix) > 0 ? 1 : 0) != 0);
                            continue;
                        }
                        MailForwardTest.assertTrue((String)"Unexpected forward prefix", (content.toString().trim().length() == 0 ? 1 : 0) != 0);
                        continue;
                    }
                    if (!UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), (Context)ctx).isForwardAsAttachment()) {
                        MailForwardTest.assertTrue((String)"Unexpected content type in file attachment", (boolean)part.getContentType().isMimeType("text/*card"));
                        continue;
                    }
                    MailForwardTest.assertTrue((String)"Unexpected content type in file attachment", (boolean)part.getContentType().isMimeType("message/rfc822"));
                }
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailForwardTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailForwardAnother() {
        try {
            MailMessage sourceMail = MimeMessageConverter.convertMessage((byte[])RFC822_FORWARD.getBytes(Charsets.US_ASCII));
            ContextImpl ctx = new ContextImpl(this.getCid());
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                boolean isInlineForward;
                MailMessage forwardMail = mailAccess.getLogicTools().getFowardMessage(new MailMessage[]{sourceMail}, false);
                UserSettingMail usm = UserSettingMailStorage.getInstance().getUserSettingMail(this.getUser(), ctx.getContextId());
                MailForwardTest.assertTrue((String)"Header 'From' does not carry expected value", (boolean)forwardMail.getFrom()[0].equals((Object)new InternetAddress(usm.getSendAddr(), true)));
                User user = UserStorage.getStorageUser((int)session.getUserId(), (Context)ctx);
                Locale locale = user.getLocale();
                TimeZone tz = TimeZone.getTimeZone(user.getTimeZone());
                StringHelper stringHelper = StringHelper.valueOf((Locale)locale);
                String subjectPrefix = "Fwd: ";
                String subject = new StringBuilder(32).append("Fwd: ").append(sourceMail.getSubject()).toString();
                MailForwardTest.assertTrue((String)"Header 'Subject' does not carry expected value", (boolean)subject.equals(forwardMail.getSubject()));
                boolean bl = isInlineForward = !UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), (Context)ctx).isForwardAsAttachment();
                if (isInlineForward) {
                    MailForwardTest.assertTrue((String)"Header 'Content-Type' does not carry expected value", (boolean)forwardMail.getContentType().isMimeType("text/plain"));
                } else {
                    MailForwardTest.assertTrue((String)"Header 'Content-Type' does not carry expected value", (boolean)forwardMail.getContentType().isMimeType("multipart/*"));
                }
                int count = forwardMail.getEnclosedCount();
                if (isInlineForward) {
                    MailForwardTest.assertTrue((String)("Unexpected number of enclosed parts: " + count), (count == -1 ? 1 : 0) != 0);
                } else {
                    MailForwardTest.assertTrue((String)("Unexpected number of enclosed parts: " + count), (count == 2 ? 1 : 0) != 0);
                }
                Object content = forwardMail.getContent();
                if (isInlineForward) {
                    MailForwardTest.assertTrue((String)"Missing content", (content != null ? 1 : 0) != 0);
                }
                if (isInlineForward) {
                    String forwardPrefix = stringHelper.getString("---------- Original Message ----------\nFrom: #FROM#\nTo: #TO##CC_LINE#\nDate: #DATE# at #TIME#\nSubject: #SUBJECT#");
                    InternetAddress[] from = sourceMail.getFrom();
                    forwardPrefix = forwardPrefix.replaceFirst("#FROM#", from == null || from.length == 0 ? "" : from[0].toUnicodeString());
                    InternetAddress[] to = sourceMail.getTo();
                    forwardPrefix = forwardPrefix.replaceFirst("#TO#", to == null || to.length == 0 ? "" : MailForwardTest.addrs2String(to));
                    InternetAddress[] cc = sourceMail.getCc();
                    forwardPrefix = forwardPrefix.replaceFirst("#CC_LINE#", cc == null || cc.length == 0 ? "" : new StringBuilder(64).append("\nCc: ").append(MailForwardTest.addrs2String(cc)).toString());
                    Date date = sourceMail.getSentDate();
                    if (date == null) {
                        forwardPrefix = forwardPrefix.replaceFirst("#DATE#", "");
                        forwardPrefix = forwardPrefix.replaceFirst("#TIME#", "");
                    } else {
                        DateFormat dateFormat = DateFormat.getDateInstance(1, locale);
                        dateFormat.setTimeZone(tz);
                        forwardPrefix = forwardPrefix.replaceFirst("#DATE#", dateFormat.format(date));
                        dateFormat = DateFormat.getTimeInstance(3, locale);
                        dateFormat.setTimeZone(tz);
                        forwardPrefix = forwardPrefix.replaceFirst("#TIME#", dateFormat.format(date));
                    }
                    forwardPrefix = forwardPrefix.replaceFirst("#SUBJECT#", sourceMail.getSubject());
                    String text = content.toString().replaceAll("(\r?\n)> ", "$1");
                    MailForwardTest.assertTrue((String)("Missing forward prefix:\n" + forwardPrefix), (text.indexOf(forwardPrefix) > 0 ? 1 : 0) != 0);
                }
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailForwardTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForwardMultiple() {
        try {
            MailAccess mailAccess;
            block9: {
                new ContextImpl(this.getCid());
                SessionObject session = this.getSession();
                mailAccess = MailAccess.getInstance((Session)session);
                mailAccess.connect();
                String[] uids = null;
                try {
                    MailMessage[] mails = new MailMessage[]{MimeMessageConverter.convertMessage((byte[])RFC822_FORWARD.getBytes(Charsets.US_ASCII)), MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII))};
                    uids = mailAccess.getMessageStorage().appendMessages("INBOX", mails);
                    MailMessage[] fetchedMails = mailAccess.getMessageStorage().getMessages("INBOX", uids, new MailField[]{MailField.FULL});
                    MailMessage forwardMail = mailAccess.getLogicTools().getFowardMessage(fetchedMails, false);
                    MailForwardTest.assertTrue((String)("Unexpected content type: " + forwardMail.getContentType().toString()), (boolean)forwardMail.getContentType().isMimeType("multipart/mixed"));
                    int count = forwardMail.getEnclosedCount();
                    MailForwardTest.assertTrue((String)("Unexpected number of attachments: " + count), (count == 3 ? 1 : 0) != 0);
                    boolean partOfFirstMailFound = false;
                    boolean partOfSecondMailFound = false;
                    for (int i = 0; i < count; ++i) {
                        MailPart part = forwardMail.getEnclosedMailPart(i);
                        if (i == 0) {
                            MailForwardTest.assertTrue((String)("Unexpected enclosed part's content type: " + part.getContentType()), (boolean)part.getContentType().isMimeType("text/*"));
                        } else {
                            MailForwardTest.assertTrue((String)("Unexpected enclosed part's content type: " + part.getContentType()), (boolean)part.getContentType().isMimeType("message/rfc822"));
                        }
                        if (i != 1 && i != 2) continue;
                        MailMessage myMail = (MailMessage)part.getContent();
                        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
                        myMail.writeTo((OutputStream)out);
                        String mailtext = new String(out.toByteArray(), Charsets.US_ASCII);
                        if (mailtext.contains("This is the first message")) {
                            partOfFirstMailFound = true;
                        }
                        if (!mailtext.contains("This is the second message")) continue;
                        partOfSecondMailFound = true;
                    }
                    MailForwardTest.assertTrue((String)"Part of first mail missing", (boolean)partOfFirstMailFound);
                    MailForwardTest.assertTrue((String)"Part of second mail missing", (boolean)partOfSecondMailFound);
                    if (uids == null) break block9;
                }
                catch (Throwable throwable) {
                    if (uids != null) {
                        mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
                    }
                    mailAccess.close(false);
                    throw throwable;
                }
                mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
            }
            mailAccess.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            MailForwardTest.fail((String)e.getMessage());
        }
    }

    private static String addrs2String(InternetAddress[] addrs) {
        StringBuilder tmp = new StringBuilder(addrs.length * 16);
        tmp.append(addrs[0].toUnicodeString());
        for (int i = 1; i < addrs.length; ++i) {
            tmp.append(", ").append(addrs[i].toUnicodeString());
        }
        return tmp.toString();
    }
}

