/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.java.Charsets;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.JsonMessageHandler;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import org.json.JSONObject;

public final class MailJSONHandlerTest
extends AbstractMailTest {
    private static final String SRC = "Return-Path: <Colton-reboil@READINGCHILDREN.COM>\nReceived: from ox.netline-is.de ([unix socket])\n\tby ox (Cyrus v2.2.3) with LMTP; Wed, 09 Apr 2008 15:25:21 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.netline-is.de (Postfix, from userid 65534)\n\tid A2D973DD171; Wed,  9 Apr 2008 15:25:21 +0200 (CEST)\nReceived: from localhost by ox.netline-is.de\n\twith SpamAssassin (2.64 2004-01-11);\n\tWed, 09 Apr 2008 15:25:21 +0200\nFrom: Ibbotson <Colton-reboil@READINGCHILDREN.COM>\nTo: \"thorben@open-xchange.org\" <thorben@open-xchange.org>\nSubject: *****SPAM***** Give your love life a boost\nDate: Wed, 9 Apr 2008 09:28:24 -0430\nMessage-Id: <3425C917.3%Colton-reboil@READINGCHILDREN.COM>\nX-Spam-Flag: YES\nX-Spam-Checker-Version: SpamAssassin 2.64 (2004-01-11) on ox.netline-is.de\nX-Spam-Level: *****\nX-Spam-Status: Yes, hits=5.9 required=5.0 tests=BAYES_90,HTML_40_50,\n\tHTML_FONTCOLOR_BLUE,HTML_FONT_BIG,HTML_MESSAGE,RCVD_NUMERIC_HELO,\n\tTO_ADDRESS_EQ_REAL autolearn=no version=2.64\nMIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"----------=_47FCC3C1.00B1B8CA\"\n\nThis is a multi-part message in MIME format.\n\n------------=_47FCC3C1.00B1B8CA\nContent-Type: text/plain\nContent-Disposition: inline\nContent-Transfer-Encoding: 8bit\n\nSpam detection software, running on the system \"ox.netline-is.de\", has\nidentified this incoming email as possible spam.  The original message\nhas been attached to this so you can view it (if it isn't spam) or block\nsimilar future email.  If you have any questions, see\nthe administrator of that system for details.\n\nContent preview:  Achieve guaranteed growth in length and girth with our\n  new product http://www.Cafennates.com/ Give your love life a boost\n  Achieve guaranteed growth in length and girth with our new product\n  URI:http://www.Cafennates.com/ http://www.Cafennates.com/ [...] \n\nContent analysis details:   (5.9 points, 5.0 required)\n\n pts rule name              description\n---- ---------------------- --------------------------------------------------\n 0.6 TO_ADDRESS_EQ_REAL     To: repeats address as real name\n 1.5 RCVD_NUMERIC_HELO      Received: contains a numeric HELO\n 0.9 HTML_40_50             BODY: Message is 40% to 50% HTML\n 2.5 BAYES_90               BODY: Bayesian spam probability is 90 to 99%\n                            [score: 0.9087]\n 0.1 HTML_FONTCOLOR_BLUE    BODY: HTML font color is blue\n 0.1 HTML_MESSAGE           BODY: HTML included in message\n 0.3 HTML_FONT_BIG          BODY: HTML has a big font\n\nThe original message was not completely plain text, and may be unsafe to\nopen with some email clients; in particular, it may contain a virus,\nor confirm that your address can receive spam.  If you wish to view\nit, it may be safer to save it to a file and open it with an editor.\n\n\n------------=_47FCC3C1.00B1B8CA\nContent-Type: message/rfc822; x-spam-type=original\nContent-Description: original message before SpamAssassin\nContent-Disposition: attachment\nContent-Transfer-Encoding: 8bit\n\nReceived: from netline.de (comfire.netline.de [192.168.32.1])\n\tby ox.netline-is.de (Postfix) with ESMTP id 39A903DD151\n\tfor <thorben@open-xchange.com>; Wed,  9 Apr 2008 15:25:21 +0200 (CEST)\nReceived: from [10.20.30.11] (helo=www.open-xchange.org ident=mail)\n\tby netline.de with esmtp (Exim)\n\tid 1Jja7v-0003JD-00\n\tfor thorben@open-xchange.com; Wed, 09 Apr 2008 15:14:11 +0200\nReceived: from mail.netline-is.de ([10.20.30.2] helo=netline.de)\n\tby www.open-xchange.org with esmtp (Exim 3.36 #1 (Debian))\n\tid 1JjaHv-0005pN-00\n\tfor <thorben@open-xchange.org>; Wed, 09 Apr 2008 15:24:31 +0200\nReceived: from [190.80.225.212] (helo=132.200.80.190.m.sta.codetel.net.do)\n\tby netline.de with esmtp (Exim)\n\tid 1Jja7t-0003J2-00\n\tfor thorben@open-xchange.org; Wed, 09 Apr 2008 15:14:09 +0200\nUser-Agent: Microsoft-Entourage/12.1.0.080305\nDate: Wed, 9 Apr 2008 09:28:24 -0430\nSubject: Give your love life a boost\nFrom: Ibbotson <Colton-reboil@READINGCHILDREN.COM>\nTo: \"thorben@open-xchange.org\" <thorben@open-xchange.org>\nMessage-ID: <3425C917.3%Colton-reboil@READINGCHILDREN.COM>\nThread-Topic: Give your love life a boost\nThread-Index: AciaJA9f0FFVg8V6TFaa2rJgYzrKpg==\nMime-version: 1.0\nContent-type: multipart/alternative;\n        boundary=\"B_8623588310_73508\"\nX-Scanner: exiscan *1Jja7t-0003J2-00*HjhzP2mBRfM* http://duncanthrax.net/exiscan/\n\n--B_8623588310_73508\nContent-type: text/plain;\n        charset=\"US-ASCII\"\nContent-transfer-encoding: 7bit\n\nAchieve guaranteed growth in length and girth with our new product http://www.Cafennates.com/\n\n\n--B_8623588310_73508\nContent-type: text/html;\n        charset=\"US-ASCII\"\nContent-transfer-encoding: quoted-printable\n\n<HTML>\n<HEAD>\n<TITLE>Give your love life a boost</TITLE>\n</HEAD>\n<BODY>\n<FONT COLOR=3D\"#000080\"><FONT SIZE=3D\"4\"><FONT FACE=3D\"Calibri, Verdana, =\nHelvetica, Arial\"><SPAN STYLE=3D'font-size:11pt'>Achieve guaranteed =\ngrowth in length and girth with our new product <a =\nhref=3D\"http://www.Cafennates.com/\">http://www.Cafennates.com/</a><BR>\n</SPAN></FONT></FONT></FONT>\n</BODY>\n</HTML>\n\n\n--B_8623588310_73508--\n\n------------=_47FCC3C1.00B1B8CA--\n\n";

    public MailJSONHandlerTest() {
    }

    public MailJSONHandlerTest(String name) {
        super(name);
    }

    public void testMailGet() {
        try {
            SessionObject session = this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SRC.getBytes(Charsets.US_ASCII));
            JsonMessageHandler handler = new JsonMessageHandler(0, "INBOX/123", DisplayMode.DISPLAY, false, (Session)session, UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId()), false, -1);
            new MailMessageParser().parseMailMessage(mail, (MailMessageHandler)handler);
            JSONObject jSONObject = handler.getJSONObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            MailJSONHandlerTest.fail((String)e.getMessage());
        }
    }
}

