/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.groupware.infostore.WebdavFolderAliases;
import com.openexchange.groupware.infostore.webdav.InMemoryAliases;
import junit.framework.TestCase;

public class WebdavFolderAliasesTest
extends TestCase {
    private WebdavFolderAliases aliases = null;
    private final String alias1 = "Alias 1";
    private final int id1 = 42;
    private final int parent1 = 23;
    private final String alias2 = "Alias 2";
    private final int id2 = 1337;
    private final int parent2 = 2017;

    public void setUp() {
        this.aliases = new InMemoryAliases();
        this.aliases.registerNameWithIDAndParent("Alias 1", 42, 23);
        this.aliases.registerNameWithIDAndParent("Alias 2", 1337, 2017);
    }

    public void testLookupByID() {
        WebdavFolderAliasesTest.assertEquals((String)"Alias 1", (String)this.aliases.getAlias(42));
        WebdavFolderAliasesTest.assertEquals((String)"Alias 2", (String)this.aliases.getAlias(1337));
        WebdavFolderAliasesTest.assertEquals(null, (String)this.aliases.getAlias(666));
    }

    public void testLookupByNameAndParent() {
        WebdavFolderAliasesTest.assertEquals((int)42, (int)this.aliases.getId("Alias 1", 23));
        WebdavFolderAliasesTest.assertEquals((int)1337, (int)this.aliases.getId("Alias 2", 2017));
        WebdavFolderAliasesTest.assertEquals((int)-1, (int)this.aliases.getId("unregistered alias", 12));
        WebdavFolderAliasesTest.assertEquals((int)-1, (int)this.aliases.getId("Alias 1", 2017));
        WebdavFolderAliasesTest.assertEquals((int)-1, (int)this.aliases.getId("Alias 2", 23));
    }
}

