/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.CopyAttachmentsForChangeExceptions;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.CalendarListener;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Charsets;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class CopyAttachmentsForChangeExceptionsTest
extends TestCase {
    private CalendarListener listener;
    private String user;
    private Context ctx;
    private CommonAppointments appointments;
    private int userId;
    private Session session;
    private AttachmentBase attachments;
    private final List<CalendarDataObject> clean = new ArrayList<CalendarDataObject>();
    private User userObject;
    private UserConfiguration userConfig;

    public void setUp() throws Exception {
        Init.startServer();
        this.attachments = new AttachmentBaseImpl((DBProvider)new DBPoolProvider());
        this.listener = new CopyAttachmentsForChangeExceptions(this.attachments);
        TestConfig config = new TestConfig();
        this.user = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        this.ctx = tools.getDefaultContext();
        this.appointments = new CommonAppointments(this.ctx, this.user);
        this.userId = tools.resolveUser(this.user, this.ctx);
        this.userObject = UserStorage.getInstance().getUser(this.userId, this.ctx);
        this.userConfig = UserConfigurationStorage.getInstance().getUserConfiguration(this.userId, this.ctx);
        this.session = tools.getSessionForUser(this.user, this.ctx);
    }

    public void tearDown() throws Exception {
        this.appointments.removeAll(this.user, this.clean);
        Init.stopServer();
    }

    public void testShouldCopyAttachments() throws OXException, IOException {
        CalendarDataObject master = this.appointments.buildBasicAppointment(CommonAppointments.D("10/02/2008 10:00"), CommonAppointments.D("10/02/2008 12:00"));
        master.setRecurrenceType(1);
        master.setInterval(1);
        master.setOccurrence(10);
        this.appointments.save(master);
        this.clean.add(master);
        CalendarDataObject exception = this.appointments.createIdentifyingCopy(master);
        exception.setRecurrencePosition(3);
        exception.setStartDate(CommonAppointments.D("13/02/2008 13:00"));
        exception.setEndDate(CommonAppointments.D("13/02/2008 15:00"));
        this.appointments.save(exception);
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setAttachedId(master.getObjectID());
        attachment.setFolderId(master.getParentFolderID());
        attachment.setModuleId(1);
        attachment.setFilename("A nice file!");
        attachment.setComment("A nice comment!");
        this.attachments.attachToObject((AttachmentMetadata)attachment, (InputStream)new ByteArrayInputStream("Hallo".getBytes(Charsets.UTF_8)), this.session, this.ctx, this.userObject, this.userConfig);
        this.listener.createdChangeExceptionInRecurringAppointment((Appointment)master, (Appointment)exception, 0, ServerSessionAdapter.valueOf((Session)this.session));
        TimedResult result = this.attachments.getAttachments(this.session, exception.getParentFolderID(), exception.getObjectID(), 1, this.ctx, this.userObject, this.userConfig);
        SearchIterator searchIterator = result.results();
        CopyAttachmentsForChangeExceptionsTest.assertTrue((boolean)searchIterator.hasNext());
        AttachmentMetadata newAttachment = (AttachmentMetadata)searchIterator.next();
        CopyAttachmentsForChangeExceptionsTest.assertFalse((boolean)searchIterator.hasNext());
        CopyAttachmentsForChangeExceptionsTest.assertTrue((attachment.getId() != newAttachment.getId() ? 1 : 0) != 0);
        CopyAttachmentsForChangeExceptionsTest.assertEquals((String)attachment.getComment(), (String)newAttachment.getComment());
        CopyAttachmentsForChangeExceptionsTest.assertEquals((String)attachment.getFilename(), (String)newAttachment.getFilename());
        InputStream is = this.attachments.getAttachedFile(this.session, exception.getParentFolderID(), exception.getObjectID(), 1, newAttachment.getId(), this.ctx, this.userObject, this.userConfig);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while ((i = is.read()) != -1) {
            out.write(i);
        }
        String data = out.toString("UTF-8");
        CopyAttachmentsForChangeExceptionsTest.assertEquals((String)"Hallo", (String)data);
    }
}

