/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.api2.RdbFolderSQLInterface;
import com.openexchange.calendar.CalendarMySQL;
import com.openexchange.calendar.CalendarOperation;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.calendar.api.AppointmentSqlFactory;
import com.openexchange.calendar.api.CalendarCollection;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.groupware.CalendarTest;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.junit.Before;

public class AppointmentBugTests
extends CalendarTest {
    int[] cols = new int[]{201, 202, 200, 206, 207, 1, 20, 221, 401};
    public static final long SUPER_END = 253402210800000L;
    public static final String TIMEZONE = "Europe/Berlin";
    private static int userid = 11;
    public static int contextid = 1;
    private static final String SQL_DEL_WORKING_DATES = "DELETE FROM prg_dates WHERE cid = ? AND intfield01 = ?";
    private static final String SQL_DEL_WORKING_MEMBERS = "DELETE FROM prg_dates_members WHERE cid = ? AND object_id = ?";
    private static final String SQL_DEL_WORKING_RIGHTS = "DELETE FROM prg_date_rights WHERE cid = ? AND object_id = ?";

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        EventConfigImpl event = new EventConfigImpl();
        event.setEventQueueEnabled(false);
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        Context ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        int user = tools.resolveUser(userName, ctx);
        contextid = ctx.getContextId();
        userid = user;
        CalendarMySQL.setApppointmentSqlFactory((AppointmentSqlFactoryService)new AppointmentSqlFactory());
    }

    @Override
    protected void tearDown() throws Exception {
        Init.stopServer();
        super.tearDown();
    }

    private static Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    private static int resolveUser(String u) throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        return uStorage.getUserId(u, AppointmentBugTests.getContext());
    }

    public static int getUserId() throws Exception {
        String user = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant2", (String)"");
        return AppointmentBugTests.resolveUser(user);
    }

    public static Context getContext() {
        try {
            TestConfig config = new TestConfig();
            TestContextToolkit tools = new TestContextToolkit();
            String ctxName = config.getContextName();
            return null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    void deleteAllAppointments() throws Exception {
        Connection readcon = DBPool.pickup((Context)AppointmentBugTests.getContext());
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"deleteAllApps");
        CalendarSql csql = new CalendarSql((Session)so);
        SearchIterator si = csql.getAppointmentsBetween(userid, new Date(0L), new Date(253402210800000L), this.cols, 0, null);
        while (si.hasNext()) {
            Appointment cdao = (Appointment)si.next();
            AppointmentBugTests.testDelete(cdao);
        }
        si.close();
        DBPool.push((Context)context, (Connection)readcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardDelete(int oid, Context ctx) {
        Connection writecon;
        try {
            writecon = DBPool.pickup((Context)ctx);
        }
        catch (OXException e) {
            e.printStackTrace();
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = writecon.prepareStatement(SQL_DEL_WORKING_DATES);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, oid);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            stmt = writecon.prepareStatement(SQL_DEL_WORKING_MEMBERS);
            pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, oid);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            stmt = writecon.prepareStatement(SQL_DEL_WORKING_RIGHTS);
            pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, oid);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            new CalendarCollection().closePreparedStatement(stmt);
        }
    }

    public static int getPrivateFolder(int userid) throws Exception {
        int privatefolder = 0;
        Context context = AppointmentBugTests.getContext();
        Connection readcon = DBPool.pickup((Context)context);
        privatefolder = CalendarTest.getCalendarDefaultFolderForUser(userid, context);
        DBPool.push((Context)context, (Connection)readcon);
        return privatefolder;
    }

    public void testBug20972() throws Exception {
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"testIdentifierForBug20972");
        UserParticipant userParticipant = new UserParticipant(userid);
        StringBuilder sb = new StringBuilder();
        String locString = "0123456789";
        for (int cap = 0; cap < locString.length() * 25; cap += locString.length()) {
            sb.append(locString);
        }
        sb.append("TRUNCATE ME");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setLocation(sb.toString());
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setIgnoreConflicts(true);
        cdao.setTitle("Testing bug 20972");
        cdao.addParticipant((Participant)userParticipant);
        cdao.setExternalOrganizer(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int oid = cdao.getObjectID();
        CalendarDataObject expected = csql.getObjectById(oid, fid);
        AppointmentBugTests.assertNotNull((String)"Object not created", (Object)expected);
        AppointmentBugTests.assertNotSame((String)"Location truncated: ", (Object)expected.getLocation(), (Object)cdao.getLocation());
    }

    public void testBug4467() throws Throwable {
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        RecurringResultsInterface m = null;
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setTimezone(TIMEZONE);
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setOccurrence(10);
        cdao.setTitle("testBug4467");
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(42);
        cdao.setIgnoreConflicts(true);
        new CalendarCollection().fillDAO(cdao);
        cdao.removeUntil();
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)"Check calculation", (int)10, (int)m.size());
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject check_cdao = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertEquals((String)"Check calculated rec_string and loaded rec_string", (String)cdao.getRecurrence(), (String)check_cdao.getRecurrence());
        AppointmentBugTests.assertEquals((String)"Check calculated occurrence and loaded occurrence", (int)cdao.getOccurrence(), (int)check_cdao.getOccurrence());
        AppointmentBugTests.assertEquals((String)"Check calculated until and loaded until", (Object)cdao.getUntil(), (Object)check_cdao.getUntil());
    }

    public void testBug4377() throws Throwable {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(AppointmentBugTests.getContext());
        cdao.setTimezone(TIMEZONE);
        cdao.setTitle("testBug4377");
        CalendarTest.fillDatesInDao(cdao);
        cdao.setEndDate(cdao.getStartDate());
        cdao.setFullTime(true);
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(1);
        cdao.setInterval(2);
        RecurringResultsInterface rss = null;
        CalendarOperation co = new CalendarOperation();
        co.prepareUpdateAction(cdao, null, userid, AppointmentBugTests.getPrivateFolder(userid), TIMEZONE);
        AppointmentBugTests.assertEquals((String)"Check that the recurring calculator is 1", (int)1, (int)cdao.getRecurrenceCalculator());
        rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        for (int a = 0; a < rss.size(); ++a) {
            RecurringResultInterface rs = rss.getRecurringResult(a);
            long check_day = rs.getEnd() - rs.getStart();
            new CalendarCollection().getClass();
            AppointmentBugTests.assertEquals((String)"Check that we got a 24 hours appointment ", (long)86400000L, (long)check_day);
        }
    }

    public void testBug4497() throws Throwable {
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = AppointmentBugTests.resolveUser(user2);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        int fid2 = AppointmentBugTests.getPrivateFolder(userid2);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)userid2, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug4497");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        UserParticipant userA = new UserParticipant(userid);
        UserParticipant userB = new UserParticipant(userid2);
        cdao.setParticipants((Participant[])new UserParticipant[]{userA, userB});
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject delete = new CalendarDataObject();
        delete.setContext(ContextStorage.getInstance().getContext(so2.getContextId()));
        delete.setObjectID(object_id);
        CalendarSql csql2 = new CalendarSql((Session)so2);
        csql2.deleteAppointmentObject(delete, fid2, new Date());
        boolean test_exists = false;
        try {
            csql2.getObjectById(object_id, fid2);
        }
        catch (OXException oxe) {
            test_exists = true;
        }
        AppointmentBugTests.assertTrue((String)"Check that User B does not have the appointment anymore in his own calendar", (boolean)test_exists);
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        UserParticipant[] up = testobject.getUsers();
        AppointmentBugTests.assertEquals((String)"Check that original appointment has only one participant left (User A)", (int)1, (int)up.length);
    }

    public void testBug4276() throws Throwable {
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = AppointmentBugTests.resolveUser(user2);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        AppointmentBugTests.getPrivateFolder(userid2);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        SessionObjectWrapper.createSessionObject((int)userid2, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug4497");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        UserParticipant userA = new UserParticipant(userid);
        UserParticipant userB = new UserParticipant(userid2);
        cdao.setUsers(new UserParticipant[]{userA, userB});
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setRecurrenceType(2);
        update.setInterval(1);
        update.setDays(2);
        update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update, fid, new Date());
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertEquals((String)"Test that app is a recurring appointment", (int)2, (int)testobject.getRecurrenceType());
    }

    public void testBug4119() throws Throwable {
        this.deleteAllAppointments();
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = AppointmentBugTests.resolveUser(user2);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        int fid2 = AppointmentBugTests.getPrivateFolder(userid2);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)userid2, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        FolderObject fo = new FolderObject();
        fo.setObjectID(fid);
        fo.setModule(2);
        fo.setType(1);
        new RdbFolderSQLInterface(ServerSessionAdapter.valueOf((Session)so)).clearFolder(fo, new Date());
        fo = new FolderObject();
        fo.setObjectID(fid2);
        fo.setModule(2);
        fo.setType(1);
        new RdbFolderSQLInterface(ServerSessionAdapter.valueOf((Session)so2)).clearFolder(fo, new Date());
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug4497");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        UserParticipant userA = new UserParticipant(userid);
        UserParticipant userB = new UserParticipant(userid2);
        cdao.setUsers(new UserParticipant[]{userA, userB});
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        Participants p = new Participants();
        ResourceParticipant resource = new ResourceParticipant(100);
        p.add((Participant)resource);
        p.add(userB);
        Participant[] pu = p.getList();
        AppointmentBugTests.assertEquals((String)"Check that we send a resource and userB", (int)2, (int)pu.length);
        update.setParticipants(pu);
        update.setIgnoreConflicts(true);
        CalendarDataObject[] conflicts = csql.updateAppointmentObject(update, fid, new Date());
        AppointmentBugTests.assertTrue((String)"Got conflicts ", (conflicts == null ? 1 : 0) != 0);
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        Participant[] participants = testobject.getParticipants();
        boolean check_userA = false;
        boolean check_userB = false;
        boolean check_Resource = false;
        for (int a = 0; a < participants.length; ++a) {
            if (participants[a].getType() == 1) {
                if (participants[a].getIdentifier() == userid) {
                    check_userA = true;
                    continue;
                }
                if (participants[a].getIdentifier() != userid2) continue;
                check_userB = true;
                continue;
            }
            if (participants[a].getType() != 3 || participants[a].getIdentifier() != 100) continue;
            check_Resource = true;
        }
        AppointmentBugTests.assertTrue((String)"Test userA", (boolean)check_userA);
        AppointmentBugTests.assertTrue((String)"Test userB", (boolean)check_userB);
        AppointmentBugTests.assertTrue((String)"Test Resource", (boolean)check_Resource);
    }

    public void testBug4473() throws Throwable {
        RecurringResultsInterface m = null;
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        long test_start_date = 1167472800000L;
        long test_end_date = 1167476400000L;
        long test_until = 1293706800000L;
        int check_day = 30;
        cdao.setStartDate(new Date(1167472800000L));
        cdao.setEndDate(new Date(1167476400000L));
        cdao.setUntil(new Date(1293706800000L));
        cdao.setTitle("testBug4473");
        cdao.setRecurrenceID(1);
        cdao.setRecurrenceType(3);
        cdao.setDayInMonth(30);
        cdao.setInterval(1);
        new CalendarCollection().fillDAO(cdao);
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        for (int a = 0; a < m.size(); ++a) {
            RecurringResultInterface rs = m.getRecurringResult(a);
            Calendar test = Calendar.getInstance();
            test.setTime(new Date(rs.getStart()));
            AppointmentBugTests.assertEquals((String)"Check day of month", (int)30, (int)test.get(5));
        }
    }

    public void testBug4766() throws Throwable {
        RecurringResultsInterface m = null;
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testBug4766");
        cdao.setFullTime(true);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.setOccurrence(2);
        cdao.setIgnoreConflicts(true);
        new CalendarCollection().fillDAO(cdao);
        cdao.removeUntil();
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)"Check size of calulated results", (int)2, (int)m.size());
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        new CalendarCollection().fillDAO(testobject);
        m = new CalendarCollection().calculateRecurring((CalendarObject)testobject, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)"Check size of calulated results", (int)2, (int)m.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug4717() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(uid2);
        oclp2.setAllPermission(4, 128, 128, 128);
        fo.setFolderName("testSharedFolder4717_" + String.valueOf(System.currentTimeMillis()));
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarSql csql2 = new CalendarSql((Session)so2);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(shared_folder_id);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testBug4717 - created by " + user2);
            cdao.setIgnoreConflicts(true);
            csql2.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject original_object = csql2.getObjectById(object_id, shared_folder_id);
            CalendarDataObject udao = new CalendarDataObject();
            udao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            udao.setObjectID(object_id);
            Date check_start_date = new Date(cdao.getStartDate().getTime() + 3600000L);
            Date check_end_date = new Date(cdao.getEndDate().getTime() + 3600000L);
            udao.setStartDate(check_start_date);
            udao.setEndDate(check_end_date);
            udao.setTitle("testBug4717 - updated by " + user2);
            Participants participants = new Participants();
            UserParticipant p = new UserParticipant(userid);
            participants.add((Participant)p);
            UserParticipant p2 = new UserParticipant(uid2);
            participants.add((Participant)p2);
            udao.setParticipants(participants.getList());
            udao.setUsers(participants.getUsers());
            udao.setIgnoreConflicts(true);
            csql2.updateAppointmentObject(udao, shared_folder_id, cdao.getLastModified());
            CalendarDataObject testobject = csql2.getObjectById(object_id, shared_folder_id);
            UserParticipant[] up = testobject.getUsers();
            AppointmentBugTests.assertTrue((String)"UserParticipant not null", (up != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Check that we got two participants ", (int)2, (int)up.length);
            AppointmentBugTests.assertEquals((String)"Check start date", (Object)check_start_date, (Object)testobject.getStartDate());
            AppointmentBugTests.assertEquals((String)"Check end date", (Object)check_end_date, (Object)testobject.getEndDate());
            CalendarDataObject second_update = new CalendarDataObject();
            second_update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            second_update.setObjectID(object_id);
            second_update.setStartDate(original_object.getStartDate());
            second_update.setEndDate(original_object.getEndDate());
            second_update.setTitle("testBug4717 - updated (2) by " + user2);
            second_update.setIgnoreConflicts(true);
            csql2.updateAppointmentObject(second_update, shared_folder_id, testobject.getLastModified());
            CalendarDataObject testobject2 = csql2.getObjectById(object_id, shared_folder_id);
            AppointmentBugTests.assertEquals((String)"Check start date", (Object)cdao.getStartDate(), (Object)testobject2.getStartDate());
            AppointmentBugTests.assertEquals((String)"Check end date", (Object)cdao.getEndDate(), (Object)testobject2.getEndDate());
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug4838() throws Throwable {
        RecurringResultsInterface m = null;
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testBug4838");
        cdao.setRecurrenceType(3);
        cdao.setInterval(1);
        cdao.setDays(2);
        cdao.setDayInMonth(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        m = new CalendarCollection().calculateRecurring((CalendarObject)testobject, 0L, 0L, 0);
        AppointmentBugTests.assertTrue((String)"Calculated results are > 0 ", (m.size() > 1 ? 1 : 0) != 0);
        int last_month = 0;
        for (int a = 0; a < m.size(); ++a) {
            RecurringResultInterface rr = m.getRecurringResult(a);
            Calendar test = Calendar.getInstance();
            test.setFirstDayOfWeek(2);
            Date date = new Date(rr.getStart());
            test.setTime(date);
            if (a > 0 && last_month != 11) {
                AppointmentBugTests.assertEquals((String)"Compare month", (int)(last_month + 1), (int)test.get(2));
            }
            AppointmentBugTests.assertEquals((String)"Check day of month", (int)2, (int)test.get(7));
            last_month = test.get(2);
        }
    }

    public void testBug5010() throws Throwable {
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testBug5010");
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(2);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertEquals((String)"Check rec type ", (int)2, (int)testobject.getRecurrenceType());
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setRecurrenceType(1);
        update.setInterval(1);
        update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update, fid, cdao.getLastModified());
        CalendarDataObject testobject2 = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertTrue((String)"Check that the recurring has been changed ", (testobject.getRecurrenceType() != testobject2.getRecurrenceType() ? 1 : 0) != 0);
        AppointmentBugTests.assertEquals((String)"Check rec type ", (int)1, (int)testobject2.getRecurrenceType());
    }

    public void testBug5012() throws Throwable {
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testBug5012");
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setStartDate(cdao.getStartDate());
        update.setEndDate(cdao.getEndDate());
        update.setRecurrenceType(1);
        update.setInterval(2);
        update.setOccurrence(0);
        update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update, fid, cdao.getLastModified());
        CalendarDataObject testobject2 = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertEquals((String)"Check that the sequence type is identical ", (int)testobject.getRecurrenceType(), (int)testobject2.getRecurrenceType());
        AppointmentBugTests.assertFalse((String)"Check that the interval has been changed", (testobject.getInterval() == testobject2.getInterval() ? 1 : 0) != 0);
        CalendarDataObject update2 = new CalendarDataObject();
        update2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update2.setObjectID(object_id);
        update2.setStartDate(cdao.getStartDate());
        update2.setEndDate(cdao.getEndDate());
        update2.setRecurrenceType(1);
        update2.setInterval(1);
        update2.setIgnoreConflicts(true);
        long l = cdao.getUntil().getTime();
        new CalendarCollection().getClass();
        Date check_until_date = new Date(l + 86400000L);
        update2.setUntil(check_until_date);
        csql.updateAppointmentObject(update2, fid, testobject2.getLastModified());
        CalendarDataObject testobject3 = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertEquals((String)"Check that the sequence type is identical ", (int)testobject.getRecurrenceType(), (int)testobject3.getRecurrenceType());
        AppointmentBugTests.assertTrue((String)"Check that the interval has been changed", (1 == testobject3.getInterval() ? 1 : 0) != 0);
        AppointmentBugTests.assertEquals((String)"Check correct until ", (Object)check_until_date, (Object)testobject3.getUntil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug5130() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(uid2);
        oclp2.setAllPermission(2, 128, 128, 0);
        fo.setFolderName("testSharedFolder5130_" + String.valueOf(System.currentTimeMillis()));
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarSql csql2 = new CalendarSql((Session)so2);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(shared_folder_id);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testBug4717 - created by " + user2);
            cdao.setIgnoreConflicts(true);
            int object_id = 0;
            try {
                csql2.insertAppointmentObject(cdao);
                object_id = cdao.getObjectID();
            }
            catch (OXException ope) {
                ope.printStackTrace();
            }
            if (object_id > 0) {
                AppointmentBugTests.fail((String)"Object could be created !");
            }
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug5144() throws Throwable {
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = AppointmentBugTests.resolveUser(user2);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        int fid2 = AppointmentBugTests.getPrivateFolder(userid2);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)userid2, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug5144");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        UserParticipant userA = new UserParticipant(userid);
        UserParticipant userB = new UserParticipant(userid2);
        cdao.setParticipants((Participant[])new UserParticipant[]{userA, userB});
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarSql csql2 = new CalendarSql((Session)so2);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject delete = new CalendarDataObject();
        delete.setContext(ContextStorage.getInstance().getContext(so2.getContextId()));
        delete.setObjectID(object_id);
        csql2.deleteAppointmentObject(delete, fid2, new Date());
        try {
            csql2.getObjectById(object_id, fid2);
            AppointmentBugTests.fail((String)"User should get an OXException ");
        }
        catch (OXException oXException) {
            // empty catch block
        }
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        UserParticipant[] up = testobject.getUsers();
        Participant[] p = testobject.getParticipants();
        AppointmentBugTests.assertEquals((String)"Check that only one userparticipant exists", (int)1, (int)up.length);
        AppointmentBugTests.assertEquals((String)"Check that only one participant exists", (int)1, (int)p.length);
    }

    public void testBug5202() throws Throwable {
        RecurringResultsInterface m = null;
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone(TIMEZONE);
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        cdao.setTitle("testBug5202");
        cdao.setRecurrenceType(4);
        cdao.setInterval(1);
        cdao.setDays(4);
        cdao.setMonth(0);
        cdao.setDayInMonth(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        m = new CalendarCollection().calculateRecurring((CalendarObject)testobject, 0L, 0L, 0);
        AppointmentBugTests.assertTrue((String)"Calculated results are > 0 ", (m.size() > 1 ? 1 : 0) != 0);
        for (int a = 0; a < m.size(); ++a) {
            RecurringResultInterface rr = m.getRecurringResult(a);
            Calendar test = Calendar.getInstance();
            test.setFirstDayOfWeek(2);
            Date date = new Date(rr.getStart());
            test.setTime(date);
            AppointmentBugTests.assertEquals((String)"Test that the day is a TUESDAY", (int)3, (int)test.get(7));
            AppointmentBugTests.assertEquals((String)"Test that the month is JAN", (int)0, (int)test.get(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug5194() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(uid2);
        oclp2.setAllPermission(4, 128, 128, 0);
        fo.setFolderName("testSharedFolder5194_" + String.valueOf(System.currentTimeMillis()));
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarSql csql = new CalendarSql((Session)so);
            CalendarSql csql2 = new CalendarSql((Session)so2);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(shared_folder_id);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testBug5194 - created by " + user2);
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject testobject = csql2.getObjectById(object_id, shared_folder_id);
            UserParticipant[] up = testobject.getUsers();
            AppointmentBugTests.assertEquals((String)"Check that only user 1 is participant", (int)1, (int)up.length);
            AppointmentBugTests.assertEquals((String)"Check that only user 1 is participant", (int)userid, (int)up[0].getIdentifier());
            CalendarDataObject update = new CalendarDataObject();
            update.setContext(ContextStorage.getInstance().getContext(so2.getContextId()));
            update.setObjectID(object_id);
            update.setTitle("testBug5194 - updated by " + user2);
            csql2.updateAppointmentObject(update, shared_folder_id, testobject.getLastModified());
            CalendarDataObject testobject2 = csql.getObjectById(object_id, shared_folder_id);
            AppointmentBugTests.assertEquals((String)"Check folder for user 1", (int)shared_folder_id, (int)testobject.getParentFolderID());
            up = testobject2.getUsers();
            AppointmentBugTests.assertEquals((String)"Check that only user 1 is participant", (int)1, (int)up.length);
            AppointmentBugTests.assertEquals((String)"Check that only user 1 is participant", (int)userid, (int)up[0].getIdentifier());
            AppointmentBugTests.assertEquals((String)"Check correct folder", (int)shared_folder_id, (int)testobject2.getParentFolderID());
            csql2.getObjectById(object_id, shared_folder_id);
            up = testobject2.getUsers();
            AppointmentBugTests.assertEquals((String)"Check that only user 1 is participant", (int)1, (int)up.length);
            AppointmentBugTests.assertEquals((String)"Check that only user 1 is participant", (int)userid, (int)up[0].getIdentifier());
            AppointmentBugTests.assertEquals((String)"Check correct folder", (int)shared_folder_id, (int)testobject2.getParentFolderID());
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug5222AND5171() throws Throwable {
        this.deleteAllAppointments();
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug5171");
        cdao.setStartDate(new Date(1168426800000L));
        cdao.setEndDate(new Date(1170154800000L));
        cdao.setFullTime(true);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertEquals((String)"Check object_id", (int)object_id, (int)testobject.getObjectID());
        long range_start = 1168815600000L;
        long range_end = 1169420400000L;
        SearchIterator si = csql.getAppointmentsBetweenInFolder(fid, this.cols, new Date(range_start), new Date(range_end), 0, null);
        boolean found = false;
        while (si.hasNext()) {
            CalendarDataObject temp = (CalendarDataObject)si.next();
            if (temp.getObjectID() != object_id) continue;
            AppointmentBugTests.assertTrue((String)"Fulltime is set to true", (boolean)temp.getFullTime());
            if (!new CalendarCollection().inBetween(temp.getStartDate().getTime(), temp.getEndDate().getTime(), range_start, range_end)) continue;
            found = true;
        }
        AppointmentBugTests.assertTrue((String)"Found no appointment (testBug5141)", (boolean)found);
        CalendarDataObject cdao2 = new CalendarDataObject();
        cdao2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao2.setParentFolderID(fid);
        cdao2.setTitle("testBug5222");
        CalendarTest.fillDatesInDao(cdao2);
        cdao2.removeUntil();
        cdao2.setFullTime(true);
        cdao2.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao2);
        int object_id2 = cdao2.getObjectID();
        testobject = csql.getObjectById(object_id2, fid);
        AppointmentBugTests.assertEquals((String)"Check object_id2", (int)object_id2, (int)testobject.getObjectID());
        range_start = new CalendarCollection().normalizeLong(cdao2.getStartDate().getTime());
        new CalendarCollection().getClass();
        range_end = range_start + 86400000L;
        si = csql.getAppointmentsBetweenInFolder(fid, this.cols, new Date(range_start), new Date(range_end), 0, null);
        found = false;
        while (si.hasNext()) {
            CalendarDataObject temp = (CalendarDataObject)si.next();
            if (temp.getObjectID() != object_id2) continue;
            AppointmentBugTests.assertTrue((String)"Fulltime is set to true", (boolean)temp.getFullTime());
            if (!new CalendarCollection().inBetween(temp.getStartDate().getTime(), temp.getEndDate().getTime(), range_start, range_end)) continue;
            found = true;
        }
        AppointmentBugTests.assertTrue((String)"Found no appointment (testBug5222)", (boolean)found);
    }

    public void testBug4987() throws Throwable {
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        long start = cdao.getStartDate().getTime();
        start = new CalendarCollection().normalizeLong(start);
        new CalendarCollection().getClass();
        long end = start + 86400000L * 2L;
        new CalendarCollection().getClass();
        int calculator = (int)((end - start) / 86400000L);
        AppointmentBugTests.assertEquals((String)"Check Calculator result ", (int)2, (int)calculator);
        cdao.setStartDate(new Date(start));
        cdao.setEndDate(new Date(end));
        cdao.setFullTime(true);
        cdao.removeUntil();
        cdao.setTitle("testBug4987");
        cdao.setRecurrenceType(1);
        cdao.setInterval(3);
        cdao.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        RecurringResultsInterface m = new CalendarCollection().calculateRecurring((CalendarObject)testobject, 0L, 0L, 0);
        AppointmentBugTests.assertTrue((String)"Calculated results are > 0 ", (m.size() > 0 ? 1 : 0) != 0);
        AppointmentBugTests.assertTrue((String)"Fulltime is set", (boolean)testobject.getFullTime());
        AppointmentBugTests.assertEquals((String)"Check that the ", (int)calculator, (int)testobject.getRecurrenceCalculator());
        for (int a = 0; a < m.size(); ++a) {
            RecurringResultInterface rr = m.getRecurringResult(a);
            long check_start = rr.getStart();
            long check_end = rr.getEnd();
            new CalendarCollection().getClass();
            int check_calculator = (int)((check_end - check_start) / 86400000L);
            AppointmentBugTests.assertEquals((String)"Check calculated results", (int)calculator, (int)check_calculator);
        }
    }

    public void testBug5306() throws Throwable {
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        new CalendarSql((Session)so);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setStartDate(TimeTools.D("24.12.2012 08:00"));
        cdao.setEndDate(TimeTools.D("24.12.2012 09:00"));
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.removeUntil();
        int OCCURRENCE_TEST = 6;
        cdao.setOccurrence(6);
        new CalendarCollection().fillDAO(cdao);
        RecurringResultsInterface m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)"Calculated results is correct", (int)6, (int)m.size());
        long super_start_test = new CalendarCollection().normalizeLong(m.getRecurringResult(m.size() - 1).getStart());
        new CalendarCollection().getClass();
        long super_end_test = super_start_test + 86400000L;
        m = new CalendarCollection().calculateRecurring((CalendarObject)cdao, super_start_test, super_end_test, 0);
        AppointmentBugTests.assertEquals((String)"Calculated results is correct", (int)1, (int)m.size());
        AppointmentBugTests.assertTrue((String)"Occurrence is set", (boolean)cdao.containsOccurrence());
        new CalendarCollection().getClass();
        new CalendarCollection().getClass();
        new Date(super_start_test += 86400000L);
        new Date(super_end_test += 86400000L);
        RecurringResultsInterface m2 = new CalendarCollection().calculateRecurring((CalendarObject)cdao, super_start_test, super_end_test, 0);
        AppointmentBugTests.assertTrue((String)"Should not got results", (m2 == null || m2.getRecurringResult(0) == null ? 1 : 0) != 0);
        Calendar calc = Calendar.getInstance();
        calc.setFirstDayOfWeek(2);
        calc.setTime(cdao.getStartDate());
        calc.set(7, 2);
        long check_week_start = calc.getTimeInMillis();
        calc.setTime(cdao.getEndDate());
        calc.set(7, 1);
        long check_week_end = calc.getTimeInMillis();
        RecurringResultsInterface m3 = new CalendarCollection().calculateRecurring((CalendarObject)cdao, check_week_start, check_week_end, 0);
        int sub_value = m3.size();
        calc.setTimeInMillis(check_week_start);
        calc.add(3, 1);
        check_week_start = calc.getTimeInMillis();
        calc.setTimeInMillis(check_week_end);
        calc.add(3, 1);
        check_week_end = calc.getTimeInMillis();
        RecurringResultsInterface m4 = new CalendarCollection().calculateRecurring((CalendarObject)cdao, check_week_start, check_week_end, 0);
        int rest_value = m4.size();
        AppointmentBugTests.assertEquals((String)"Calculated results is correct", (int)6, (int)(sub_value + rest_value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noTestBug6910() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        int fid2 = AppointmentBugTests.getPrivateFolder(uid2);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so2, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(uid2);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(userid);
        oclp2.setAllPermission(4, 128, 128, 128);
        fo.setFolderName("testSharedFolder6910");
        fo.setParentFolderID(fid2);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarSql csql = new CalendarSql((Session)so);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(fid);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testBug6910 - Step 1");
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject testobject = csql.getObjectById(object_id, fid);
            UserParticipant[] up = testobject.getUsers();
            AppointmentBugTests.assertTrue((String)"up > 0", (up.length > 0 ? 1 : 0) != 0);
            CalendarDataObject update = new CalendarDataObject();
            update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update.setObjectID(object_id);
            update.setParentFolderID(shared_folder_id);
            update.setIgnoreConflicts(true);
            update.setTitle("testBug6910 - Step 2");
            csql.updateAppointmentObject(update, fid, cdao.getLastModified());
            CalendarSql csql2 = new CalendarSql((Session)so2);
            testobject = csql2.getObjectById(object_id, shared_folder_id);
            UserParticipant[] user_test = testobject.getUsers();
            boolean found_user1 = false;
            boolean found_user2 = false;
            for (int a = 0; a < user_test.length; ++a) {
                if (user_test[a].getIdentifier() == userid) {
                    found_user1 = true;
                }
                if (user_test[a].getIdentifier() != uid2) continue;
                found_user2 = true;
            }
            AppointmentBugTests.assertTrue((String)"User A is not in the participants", (boolean)found_user1);
            AppointmentBugTests.assertTrue((String)"User B is not in the participants", (boolean)found_user2);
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBug6400() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        fo.setFolderName("testBug6400 - " + System.currentTimeMillis());
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1});
        int subfolder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            subfolder_id = fo.getObjectID();
            CalendarSql csql = new CalendarSql((Session)so);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(subfolder_id);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testBug6400 - Step 1");
            cdao.setIgnoreConflicts(true);
            cdao.setRecurrenceType(1);
            cdao.setInterval(1);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject testobject = csql.getObjectById(object_id, subfolder_id);
            testobject.getStartDate();
            testobject.getEndDate();
            CalendarDataObject update = new CalendarDataObject();
            update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update.setTitle("testBug6400 - Step 2");
            update.setObjectID(object_id);
            update.setRecurrencePosition(1);
            update.setIgnoreConflicts(true);
            update.setParentFolderID(fid);
            try {
                csql.updateAppointmentObject(update, subfolder_id, new Date());
                update.getObjectID();
                AppointmentBugTests.fail((String)"Test failed. An exception can not be moved into a different folder.");
            }
            catch (OXException e) {
                AppointmentBugTests.assertEquals((String)"Check correct error message", (int)66, (int)e.getCode());
            }
        }
        finally {
            try {
                if (subfolder_id > 0) {
                    oxma.deleteFolder(new FolderObject(subfolder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug6214() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        fo.setFolderName("testBug6214 " + System.currentTimeMillis());
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1});
        int subfolder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            subfolder_id = fo.getObjectID();
            CalendarSql csql = new CalendarSql((Session)so);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(fid);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testBug6214 - Step 1");
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject update = csql.getObjectById(object_id, fid);
            UserParticipant[] up_insert = update.getUsers();
            AppointmentBugTests.assertTrue((String)"Got a participant", (up_insert != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Check that no alarm is set (insert)", (boolean)false, (boolean)up_insert[0].containsAlarm());
            update.setTitle("testBug6214 - Step 2");
            update.setIgnoreConflicts(true);
            update.setParentFolderID(subfolder_id);
            csql.updateAppointmentObject(update, fid, cdao.getLastModified());
            CalendarDataObject testobject = csql.getObjectById(object_id, subfolder_id);
            UserParticipant[] up_update = testobject.getUsers();
            AppointmentBugTests.assertTrue((String)"Got a participant", (up_update != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Check that no alarm is set (update)", (boolean)false, (boolean)up_update[0].containsAlarm());
        }
        finally {
            try {
                if (subfolder_id > 0) {
                    oxma.deleteFolder(new FolderObject(subfolder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug6535() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testBug6535 - Step 1");
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        UserParticipant userparticipants = new UserParticipant(userid);
        userparticipants.setConfirm(1);
        cdao.setUsers(new UserParticipant[]{userparticipants});
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        UserParticipant[] up1 = testobject.getUsers();
        AppointmentBugTests.assertTrue((String)"Check for null object", (up1 != null ? 1 : 0) != 0);
        AppointmentBugTests.assertEquals((String)"Check confirm status", (int)1, (int)up1[0].getConfirm());
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setParentFolderID(fid);
        update.setRecurrencePosition(1);
        update.setStartDate(new Date(testobject.getStartDate().getTime() + 3600000L));
        update.setEndDate(new Date(testobject.getEndDate().getTime() + 3600000L));
        update.setIgnoreConflicts(true);
        update.setUsers(up1);
        update.setTitle("testBug6535 - Exception");
        csql.updateAppointmentObject(update, fid, cdao.getLastModified());
        CalendarDataObject testobject_exception = csql.getObjectById(update.getObjectID(), fid);
        UserParticipant[] up2 = testobject_exception.getUsers();
        AppointmentBugTests.assertTrue((String)"Check for null object", (up2 != null ? 1 : 0) != 0);
        AppointmentBugTests.assertEquals((String)"Check confirm status", (int)1, (int)up2[0].getConfirm());
        CalendarDataObject testobject_after_update = csql.getObjectById(object_id, fid);
        UserParticipant[] up3 = testobject_after_update.getUsers();
        AppointmentBugTests.assertTrue((String)"Check for null object", (up3 != null ? 1 : 0) != 0);
        AppointmentBugTests.assertEquals((String)"Check confirm status", (int)1, (int)up3[0].getConfirm());
    }

    public void testBug6960() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testBug6960");
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        cdao.getLastModified();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 3);
        RecurringResultInterface rs = rss.getRecurringResult(0);
        long new_start = rs.getStart() + 3600000L;
        long new_end = rs.getEnd() + 3600000L;
        Date test_new_start_date = new Date(new_start);
        Date test_new_end_date = new Date(new_end);
        update.setStartDate(test_new_start_date);
        update.setEndDate(test_new_end_date);
        update.setTitle("testBug6960 - Exception");
        Date test_exception_date = new Date(new CalendarCollection().normalizeLong(new_start));
        update.setRecurrenceDatePosition(test_exception_date);
        csql.updateAppointmentObject(update, folder_id, new Date());
        CalendarDataObject testdelete = new CalendarDataObject();
        testdelete.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        testdelete.setObjectID(update.getObjectID());
        csql.deleteAppointmentObject(testdelete, folder_id, new Date());
        AppointmentBugTests.assertTrue((String)"Check that we got the recurrence id back", (boolean)testdelete.containsRecurrenceID());
        AppointmentBugTests.assertEquals((String)"Check that we got the correct recurrence id", (int)object_id, (int)testdelete.getRecurrenceID());
    }

    public void testBug7883() throws Throwable {
        CalendarDataObject tdao;
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = AppointmentBugTests.resolveUser(user2);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        int fid2 = AppointmentBugTests.getPrivateFolder(userid2);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)userid2, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug7883");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        UserParticipant userA = new UserParticipant(userid);
        userA.setAlarmMinutes(15);
        UserParticipant userB = new UserParticipant(userid2);
        cdao.setUsers(new UserParticipant[]{userA, userB});
        cdao.setParticipants((Participant[])new UserParticipant[]{userA, userB});
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarSql csql2 = new CalendarSql((Session)so2);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertTrue((String)"Check that userA has an alarm set in the cdao", (boolean)testobject.containsAlarm());
        AppointmentBugTests.assertEquals((String)"Check that we got a 15", (int)15, (int)testobject.getAlarm());
        CalendarDataObject testobject2 = csql2.getObjectById(object_id, fid2);
        AppointmentBugTests.assertTrue((String)"Check that userB has no alarm set in the cdao", (!testobject2.containsAlarm() ? 1 : 0) != 0);
        SearchIterator si = csql.getModifiedAppointmentsInFolder(fid, this.cols, AppointmentBugTests.decrementDate(cdao.getLastModified()));
        boolean found = false;
        while (si.hasNext()) {
            CalendarDataObject tdao2 = (CalendarDataObject)si.next();
            if (!tdao2.getTitle().equals("testBug7883")) continue;
            found = true;
            AppointmentBugTests.assertTrue((String)"Check that userA has an alarm set in the cdao", (boolean)tdao2.containsAlarm());
            AppointmentBugTests.assertEquals((String)"Check that we got a 15", (int)15, (int)tdao2.getAlarm());
        }
        AppointmentBugTests.assertTrue((String)"Found our object (userA)", (boolean)found);
        SearchIterator si2 = csql2.getModifiedAppointmentsInFolder(fid2, this.cols, AppointmentBugTests.decrementDate(cdao.getLastModified()));
        found = false;
        while (si2.hasNext()) {
            CalendarDataObject tdao3 = (CalendarDataObject)si2.next();
            if (!tdao3.getTitle().equals("testBug7883")) continue;
            found = true;
            AppointmentBugTests.assertTrue((String)"Check that userB has no alarm set in the cdao", (!tdao3.containsAlarm() ? 1 : 0) != 0);
        }
        AppointmentBugTests.assertTrue((String)"Found our object (userB)", (boolean)found);
        CalendarDataObject cdao_update = new CalendarDataObject();
        cdao_update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao_update.setTitle("testBug7883-update");
        cdao_update.setObjectID(object_id);
        userA = new UserParticipant(userid);
        cdao_update.setAlarm(-1);
        cdao_update.setUsers(new UserParticipant[]{userA, userB});
        cdao_update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(cdao_update, fid, cdao.getLastModified());
        testobject = csql.getObjectById(object_id, fid);
        AppointmentBugTests.assertTrue((String)"Check that userA has no alarm set in the cdao", (!testobject.containsAlarm() ? 1 : 0) != 0);
        testobject2 = csql2.getObjectById(object_id, fid2);
        AppointmentBugTests.assertTrue((String)"Check that userB has no alarm set in the cdao", (!testobject2.containsAlarm() ? 1 : 0) != 0);
        si = csql.getModifiedAppointmentsInFolder(fid, this.cols, AppointmentBugTests.decrementDate(cdao.getLastModified()));
        found = false;
        while (si.hasNext()) {
            tdao = (CalendarDataObject)si.next();
            if (!tdao.getTitle().equals("testBug7883-update")) continue;
            found = true;
            AppointmentBugTests.assertTrue((String)"Check that userA has no alarm set in the cdao", (!tdao.containsAlarm() ? 1 : 0) != 0);
        }
        AppointmentBugTests.assertTrue((String)"Found our object (userA)", (boolean)found);
        si2 = csql2.getModifiedAppointmentsInFolder(fid2, this.cols, AppointmentBugTests.decrementDate(cdao.getLastModified()));
        found = false;
        while (si2.hasNext()) {
            tdao = (CalendarDataObject)si2.next();
            if (!tdao.getTitle().equals("testBug7883-update")) continue;
            found = true;
            AppointmentBugTests.assertTrue((String)"Check that userB has no alarm set in the cdao", (!tdao.containsAlarm() ? 1 : 0) != 0);
        }
        AppointmentBugTests.assertTrue((String)"Found our object (userB)", (boolean)found);
    }

    public void testBug7646() throws Throwable {
        this.deleteAllAppointments();
        ContextImpl context = new ContextImpl(contextid);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        FolderObject fo = new FolderObject();
        fo.setObjectID(fid);
        fo.setModule(2);
        fo.setType(1);
        new RdbFolderSQLInterface(ServerSessionAdapter.valueOf((Session)so)).clearFolder(fo, new Date());
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setTitle("testBug7646 - #1");
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setStartDate(new Date(cdao.getStartDate().getTime() + 3600000L));
        cdao.setEndDate(new Date(cdao.getEndDate().getTime() + 0x6DDD00L));
        Participants p = new Participants();
        ResourceParticipant resource = new ResourceParticipant(100);
        p.add((Participant)resource);
        cdao.setParticipants(p.getList());
        cdao.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Got an object id", (object_id > 0 ? 1 : 0) != 0);
        CalendarDataObject cdao_conflict_test = new CalendarDataObject();
        cdao_conflict_test.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao_conflict_test.setTitle("testBug7646 - #2");
        cdao_conflict_test.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao_conflict_test);
        cdao_conflict_test.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = csql.insertAppointmentObject(cdao_conflict_test);
        int object_id2 = cdao_conflict_test.getObjectID();
        AppointmentBugTests.assertTrue((String)"Got an object id", (object_id2 > 0 ? 1 : 0) != 0);
        boolean found_object_1 = false;
        if (conflicts != null) {
            for (int a = 0; a < conflicts.length; ++a) {
                if (conflicts[a].getObjectID() != object_id) continue;
                found_object_1 = true;
            }
        }
        AppointmentBugTests.assertTrue((String)"Conflicted with object #1!", (!found_object_1 ? 1 : 0) != 0);
        CalendarDataObject testobject = csql.getObjectById(object_id2, fid);
        testobject.removeStartDate();
        testobject.removeEndDate();
        testobject.setParticipants(p.getList());
        testobject.setIgnoreConflicts(false);
        conflicts = csql.updateAppointmentObject(testobject, fid, cdao_conflict_test.getLastModified());
        found_object_1 = false;
        if (conflicts != null) {
            for (int a = 0; a < conflicts.length; ++a) {
                if (conflicts[a].getObjectID() != object_id) continue;
                found_object_1 = true;
            }
        }
        AppointmentBugTests.assertTrue((String)"Conflicted with object #1!", (!found_object_1 ? 1 : 0) != 0);
        csql.deleteAppointmentObject(cdao, fid, cdao.getLastModified());
        csql.deleteAppointmentObject(testobject, fid, testobject.getLastModified());
    }

    public void testBug7064() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug7064");
        long startdate = 1175421600000L;
        long enddate = 1175425200000L;
        long[] testmatrix = new long[]{1176804000000L, 1208253600000L, 1240308000000L, 1271757600000L};
        cdao.setStartDate(new Date(1175421600000L));
        cdao.setEndDate(new Date(1175425200000L));
        cdao.setRecurrenceType(4);
        cdao.setDays(4);
        cdao.setDayInMonth(3);
        cdao.setMonth(3);
        cdao.setInterval(1);
        cdao.setOccurrence(testmatrix.length);
        new CalendarCollection().fillDAO(cdao);
        RecurringResultsInterface rrs = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)"Check result size", (int)testmatrix.length, (int)rrs.size());
        for (int a = 0; a < rrs.size(); ++a) {
            RecurringResultInterface rs = rrs.getRecurringResult(a);
            AppointmentBugTests.assertEquals((String)("Check start time (" + a + ")"), (Object)new Date(testmatrix[a]), (Object)new Date(rs.getStart()));
        }
    }

    public void testBug8290() throws Throwable {
        this.deleteAllAppointments();
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        long teststarttime = 1188165600000L;
        long testendtime = 1191103200000L;
        Date teststartdate = new Date(1188165600000L);
        Date testenddate = new Date(1191103200000L);
        CalendarSql csql = new CalendarSql((Session)so);
        boolean[] testarray = csql.hasAppointmentsBetween(teststartdate, testenddate);
        boolean check_all_false = true;
        for (int a = 0; a < testarray.length; ++a) {
            if (!testarray[a]) continue;
            check_all_false = false;
        }
        AppointmentBugTests.assertTrue((String)"Got results, but this test works only if no results are given at start time!", (boolean)check_all_false);
        long starttime = 1187560800000L;
        long endtime = 1188511200000L;
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        cdao.setParentFolderID(fid);
        cdao.setStartDate(new Date(1187560800000L));
        cdao.setEndDate(new Date(1188511200000L));
        cdao.setFullTime(true);
        cdao.setTitle("testBug8290");
        cdao.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao);
        testarray = csql.hasAppointmentsBetween(teststartdate, testenddate);
        boolean[] checkarray = new boolean[]{true, true, true, true, false, false, false, false, false, false};
        for (int a = 0; a < checkarray.length; ++a) {
            AppointmentBugTests.assertEquals((String)("Check array position " + a + " failed!"), (boolean)checkarray[a], (boolean)testarray[a]);
        }
    }

    public void testBug7134() throws Throwable {
        this.deleteAllAppointments();
        ContextImpl context = new ContextImpl(contextid);
        SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        long starttime = 1180692000000L;
        long endtime = 1180695600000L;
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        cdao.setParentFolderID(fid);
        cdao.setStartDate(new Date(1180692000000L));
        cdao.setEndDate(new Date(1180695600000L));
        cdao.setFullTime(true);
        cdao.setTitle("testBug7134");
        cdao.setIgnoreConflicts(true);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(2);
        cdao.setOccurrence(3);
        new CalendarCollection().fillDAO(cdao);
        RecurringResultsInterface rrs = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)"Check that we got 3 results", (int)3, (int)rrs.size());
    }

    public void testBug8317() throws Throwable {
        this.deleteAllAppointments();
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setParentFolderID(fid);
        cdao.setTimezone(TIMEZONE);
        Calendar calendar = TimeTools.createCalendar(TimeZone.getTimeZone("UTC"));
        calendar.add(5, 1);
        calendar.set(11, 0);
        cdao.setStartDate(calendar.getTime());
        calendar.add(11, 24);
        cdao.setEndDate(calendar.getTime());
        cdao.setFullTime(true);
        cdao.setTitle("testBug8317");
        cdao.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Got an object id", (object_id > 0 ? 1 : 0) != 0);
        CalendarDataObject cdao2 = new CalendarDataObject();
        cdao2.setContext((Context)context);
        cdao2.setParentFolderID(fid);
        cdao2.setTimezone(TIMEZONE);
        calendar = TimeTools.createCalendar(TimeZone.getTimeZone(TIMEZONE));
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 30);
        cdao2.setStartDate(calendar.getTime());
        calendar.add(12, 30);
        cdao2.setEndDate(calendar.getTime());
        cdao2.setTitle("testBug8317 - 2");
        CalendarDataObject[] conflicts = csql.insertAppointmentObject(cdao2);
        AppointmentBugTests.assertTrue((String)"Got no conflicts", (conflicts != null && conflicts.length > 0 ? 1 : 0) != 0);
        boolean found_object_1 = false;
        if (conflicts != null) {
            for (int a = 0; a < conflicts.length; ++a) {
                if (conflicts[a].getObjectID() != object_id) continue;
                found_object_1 = true;
            }
        }
        AppointmentBugTests.assertTrue((String)"No conflict with object #1!", (boolean)found_object_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug8490() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarSql csql2 = new CalendarSql((Session)so2);
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(uid2);
        oclp2.setAllPermission(2, 4, 0, 0);
        fo.setFolderName("testSharedFolder8490 - " + System.currentTimeMillis());
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(shared_folder_id);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setIgnoreConflicts(true);
            UserParticipant up = new UserParticipant(userid);
            UserParticipant up2 = new UserParticipant(uid2);
            cdao.setUsers(new UserParticipant[]{up, up2});
            cdao.setTitle("testBug8490");
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject update = new CalendarDataObject();
            update.setContext(ContextStorage.getInstance().getContext(so2.getContextId()));
            update.setObjectID(object_id);
            update.setTimezone("testBug8490- update (user2)");
            update.setIgnoreConflicts(true);
            try {
                csql2.updateAppointmentObject(update, shared_folder_id, new Date());
            }
            catch (OXException oXException) {
                // empty catch block
            }
            boolean found = false;
            SearchIterator si = csql2.getModifiedAppointmentsInFolder(shared_folder_id, CalendarTest.cols, new Date(0L));
            while (si.hasNext()) {
                CalendarDataObject tdao = (CalendarDataObject)si.next();
                if (tdao.getObjectID() != object_id) continue;
                found = true;
                AppointmentBugTests.assertEquals((String)"Check for correct folder id in response object", (int)shared_folder_id, (int)tdao.getParentFolderID());
            }
            AppointmentBugTests.assertTrue((String)"Found object", (boolean)found);
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug8482() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        int fid2 = AppointmentBugTests.getPrivateFolder(uid2);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so2, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        CalendarSql csql = new CalendarSql((Session)so);
        new CalendarSql((Session)so2);
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(uid2);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(userid);
        oclp2.setAllPermission(4, 128, 128, 128);
        fo.setFolderName("testSharedFolder8482 - " + System.currentTimeMillis());
        fo.setParentFolderID(fid2);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setTitle("testBug8482");
            CalendarTest.fillDatesInDao(cdao);
            cdao.setPrivateFlag(true);
            cdao.setParentFolderID(fid);
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarDataObject move = new CalendarDataObject();
            move.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            move.setObjectID(object_id);
            move.setParentFolderID(shared_folder_id);
            try {
                csql.updateAppointmentObject(move, fid, new Date());
                AppointmentBugTests.fail((String)"Move not allowed");
            }
            catch (OXException oXException) {
            }
            catch (Exception e) {
                AppointmentBugTests.fail((String)("Noooo " + e.getMessage()));
            }
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug8510() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        cdao.setTimezone(TIMEZONE);
        cdao.setTitle("testBug8510");
        CalendarTest.fillDatesInDao(cdao);
        cdao.setParentFolderID(fid);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        int rec_reminder = 60;
        cdao.setAlarm(60);
        cdao.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Got object_id", (object_id > 0 ? 1 : 0) != 0);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext((Context)context);
        update.setObjectID(object_id);
        update.setTimezone(TIMEZONE);
        int exc_reminder = 15;
        update.setAlarm(15);
        update.setTitle("testBug8510 - Exception 2");
        update.setIgnoreConflicts(true);
        update.setRecurrencePosition(2);
        csql.updateAppointmentObject(update, fid, new Date());
        int object_id2 = update.getObjectID();
        AppointmentBugTests.assertTrue((String)"Got new object_id", (object_id2 > 0 && object_id2 != object_id ? 1 : 0) != 0);
        SearchIterator si = csql.getModifiedAppointmentsInFolder(fid, CalendarTest.cols, cdao.getLastModified());
        int check_rec_reminder = -1;
        int check_exc_reminder = -1;
        while (si.hasNext()) {
            CalendarDataObject tcdao = (CalendarDataObject)si.next();
            if (tcdao.getObjectID() == object_id) {
                check_rec_reminder = tcdao.getAlarm();
                continue;
            }
            if (tcdao.getObjectID() != object_id2) continue;
            check_exc_reminder = tcdao.getAlarm();
        }
        si.close();
        AppointmentBugTests.assertTrue((String)"Got two reminder", (check_exc_reminder > 0 && check_rec_reminder > 0 ? 1 : 0) != 0);
        AppointmentBugTests.assertEquals((String)"Recurring reminder", (int)60, (int)check_rec_reminder);
        AppointmentBugTests.assertEquals((String)"Excption reminder", (int)15, (int)check_exc_reminder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug8495() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        int fid2 = AppointmentBugTests.getPrivateFolder(uid2);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarSql csql2 = new CalendarSql((Session)so2);
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(uid2);
        oclp2.setAllPermission(4, 128, 128, 128);
        oclp2.setFolderAdmin(false);
        fo.setFolderName("testSharedFolder8495 - " + System.currentTimeMillis());
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setTitle("testBug8495");
            CalendarTest.fillDatesInDao(cdao);
            cdao.setParentFolderID(fid);
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
            csql2.getObjectById(object_id, shared_folder_id);
            CalendarDataObject move = new CalendarDataObject();
            move.setContext(ContextStorage.getInstance().getContext(so2.getContextId()));
            move.setObjectID(object_id);
            move.setParentFolderID(fid2);
            csql2.updateAppointmentObject(move, shared_folder_id, new Date());
            CalendarDataObject moved = csql2.getObjectById(object_id, shared_folder_id);
            AppointmentBugTests.assertNotNull((String)"Should find the newly moved appointment", (Object)moved);
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug7734() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)context);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setParentFolderID(fid);
        cdao.setTimezone(TIMEZONE);
        cdao.setTitle("testBug7734");
        int alarm = 60;
        long long_alarm = 3600000L;
        long l = cdao.getStartDate().getTime();
        new CalendarCollection().getClass();
        long start_long = l + 86400000L;
        Date start_date = new Date(start_long);
        long l2 = cdao.getEndDate().getTime();
        new CalendarCollection().getClass();
        long end_long = l2 + 86400000L;
        Date end_date = new Date(end_long);
        cdao.setStartDate(start_date);
        cdao.setEndDate(end_date);
        cdao.setAlarm(60);
        Date check_alarm = new Date(start_long - 3600000L);
        cdao.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Got object_id", (object_id > 0 ? 1 : 0) != 0);
        ReminderHandler rh = new ReminderHandler(AppointmentBugTests.getContext());
        ReminderObject ro = rh.loadReminder(object_id, userid, 1);
        Date check_date = ro.getDate();
        AppointmentBugTests.assertEquals((String)"Check correct Alarm", (Object)check_alarm, (Object)check_date);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext((Context)context);
        update.setObjectID(object_id);
        long start_long_update = start_long - 3600000L;
        Date update_start = new Date(start_long_update);
        Date update_end = new Date(end_long - 3600000L);
        Date check_alarm_update = new Date(start_long_update - 3600000L);
        update.setStartDate(update_start);
        update.setEndDate(update_end);
        update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update, fid, new Date());
        ro = rh.loadReminder(object_id, userid, 1);
        Date check_date_update = ro.getDate();
        AppointmentBugTests.assertEquals((String)"Check correct Alarm", (Object)check_alarm_update, (Object)check_date_update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug9089() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        CalendarSql csql = new CalendarSql((Session)so);
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        new OCLPermission();
        fo.setFolderName("testPublicFolder9089 - " + System.currentTimeMillis());
        fo.setParentFolderID(2);
        fo.setModule(2);
        fo.setType(2);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1});
        int public_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            public_folder_id = fo.getObjectID();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setTitle("testBug9089");
            CalendarTest.fillDatesInDao(cdao);
            cdao.setParentFolderID(public_folder_id);
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
            CalendarDataObject update = new CalendarDataObject();
            update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update.setNote("Mark as private should not worl!");
            update.setObjectID(object_id);
            update.setIgnoreConflicts(true);
            update.setPrivateFlag(true);
            try {
                csql.updateAppointmentObject(update, public_folder_id, new Date());
                AppointmentBugTests.fail((String)"Set the private flag is not allowed in a public folder");
            }
            catch (OXException oxca) {
                AppointmentBugTests.assertTrue((String)"Check correct error number ", (boolean)oxca.similarTo((OXExceptionCode)OXCalendarExceptionCodes.PIVATE_FLAG_ONLY_IN_PRIVATE_FOLDER));
            }
        }
        finally {
            try {
                if (public_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(public_folder_id), true, System.currentTimeMillis());
                } else {
                    AppointmentBugTests.fail((String)"Public folder was not created");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug9599() throws Throwable {
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug9599");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        Participants participants = new Participants();
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = AppointmentBugTests.resolveUser(user2);
        UserParticipant p2 = new UserParticipant(userid2);
        participants.add((Participant)p2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)userid2, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        cdao.setParticipants(participants.getList());
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarSql csql2 = new CalendarSql((Session)so2);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
        String confirm_message = "jaja";
        int fid2 = AppointmentBugTests.getPrivateFolder(userid2);
        csql.setUserConfirmation(object_id, fid, userid, 1, "jaja");
        csql2.setUserConfirmation(object_id, fid2, userid2, 1, "jaja");
        String user3 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant1", (String)"");
        int userid3 = AppointmentBugTests.resolveUser(user3);
        UserParticipant p3 = new UserParticipant(userid3);
        participants.add((Participant)p3);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setParticipants(participants.getList());
        update.setIgnoreConflicts(true);
        update.setObjectID(object_id);
        csql.updateAppointmentObject(update, fid, new Date());
        CalendarDataObject temp = csql.getObjectById(object_id, fid);
        UserParticipant[] up = temp.getUsers();
        for (int a = 0; a < up.length; ++a) {
            if (up[a].getIdentifier() == userid) {
                AppointmentBugTests.assertEquals((String)("Check confirm state for user " + up[a].getIdentifier()), (int)1, (int)up[a].getConfirm());
                AppointmentBugTests.assertEquals((String)("Check confirm message for user " + up[a].getIdentifier()), (String)"jaja", (String)up[a].getConfirmMessage());
                continue;
            }
            if (up[a].getIdentifier() != userid2) continue;
            AppointmentBugTests.assertEquals((String)("Check confirm state for user " + up[a].getIdentifier()), (int)1, (int)up[a].getConfirm());
            AppointmentBugTests.assertEquals((String)("Check confirm message for user " + up[a].getIdentifier()), (String)"jaja", (String)up[a].getConfirmMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug10154() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = AppointmentBugTests.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        String user3 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant1", (String)"");
        int userid3 = AppointmentBugTests.resolveUser(user3);
        UserParticipant p1 = new UserParticipant(userid);
        UserParticipant p2 = new UserParticipant(uid2);
        UserParticipant p3 = new UserParticipant(userid3);
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(uid2);
        oclp2.setAllPermission(4, 128, 128, 128);
        fo.setFolderName("testSharedFolder10154 - " + System.currentTimeMillis());
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        int shared_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            shared_folder_id = fo.getObjectID();
            CalendarSql csql = new CalendarSql((Session)so);
            CalendarSql csql2 = new CalendarSql((Session)so2);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(shared_folder_id);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testBug10154 - step 1");
            cdao.setIgnoreConflicts(true);
            csql2.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
            CalendarDataObject update = new CalendarDataObject();
            update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            Participants participants = new Participants();
            participants.add((Participant)p1);
            participants.add((Participant)p2);
            participants.add((Participant)p3);
            update.setParticipants(participants.getList());
            update.setIgnoreConflicts(true);
            update.setObjectID(object_id);
            update.setTitle("testBug10154 - step 2");
            csql.updateAppointmentObject(update, shared_folder_id, new Date());
            CalendarDataObject update2 = new CalendarDataObject();
            update2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update2.setObjectID(object_id);
            Date check_start_date = new Date(cdao.getStartDate().getTime() + 3600000L);
            Date check_end_date = new Date(cdao.getEndDate().getTime() + 3600000L);
            update2.setStartDate(check_start_date);
            update2.setEndDate(check_end_date);
            update2.setTitle("testBug10154 - step 3");
            csql2.updateAppointmentObject(update2, shared_folder_id, new Date());
            CalendarDataObject temp = csql.getObjectById(object_id, shared_folder_id);
            Object[] up = temp.getUsers();
            int[] check = new int[]{userid, uid2, userid3};
            AppointmentBugTests.assertEquals((String)"Check participants", (int)3, (int)check.length);
            Arrays.sort(up);
            Arrays.sort(check);
            for (int a = 0; a < check.length; ++a) {
                int x = Arrays.binarySearch(check, up[a].getIdentifier());
                if (x >= 0) continue;
                AppointmentBugTests.fail((String)("User " + up[a].getIdentifier() + " not found!"));
            }
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AppointmentBugTests.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testBug10717() throws Throwable {
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug10717");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        Participants participants = new Participants();
        String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = AppointmentBugTests.resolveUser(user2);
        UserParticipant p1 = new UserParticipant(userid);
        participants.add((Participant)p1);
        UserParticipant p2 = new UserParticipant(userid2);
        participants.add((Participant)p2);
        update.setParticipants(participants.getList());
        update.setIgnoreConflicts(true);
        update.setObjectID(object_id);
        update.setTitle("testBug10154 - step 2");
        csql.updateAppointmentObject(update, fid, new Date());
        AppointmentBugTests.assertEquals((String)"Check participants length", (int)2, (int)update.getParticipants().length);
        CalendarDataObject update_user_delete = new CalendarDataObject();
        update_user_delete.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        participants = new Participants();
        participants.add((Participant)p1);
        update_user_delete.setParticipants(participants.getList());
        update_user_delete.setIgnoreConflicts(true);
        update_user_delete.setObjectID(object_id);
        update_user_delete.setTitle("testBug10154 - step 2");
        csql.updateAppointmentObject(update_user_delete, fid, new Date());
        AppointmentBugTests.assertEquals((String)"Check participants length", (int)1, (int)update_user_delete.getParticipants().length);
    }

    public void testBug10663() throws Exception {
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug10663");
        cdao.setIgnoreConflicts(true);
        cdao.setStartDate(new Date(1198238400000L));
        cdao.setEndDate(new Date(1198242000000L));
        cdao.setUntil(new Date(1211068800000L));
        cdao.setRecurrenceCalculator(0);
        cdao.setRecurrenceType(3);
        cdao.setInterval(1);
        cdao.setDays(2);
        cdao.setDayInMonth(2);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
        AppointmentBugTests.assertTrue((String)("Unexpected recurrence string: " + cdao.getRecurrence() + ". Should be: t|5|i|1|a|2|b|2|s|1198238400000|e|1211068800000|"), (boolean)"t|5|i|1|a|2|b|2|s|1198238400000|e|1211068800000|".equals(cdao.getRecurrence()));
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)("Unexpected number of occurrences: " + rss.size() + ". Should be: " + 5), (int)5, (int)rss.size());
    }

    public void testBug8516() throws Exception {
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug8516");
        cdao.setIgnoreConflicts(true);
        cdao.setTimezone("America/New_York");
        cdao.setStartDate(new Date(1219271400000L));
        cdao.setEndDate(new Date(1219275000000L));
        cdao.setUntil(new Date(1219449600000L));
        cdao.setRecurrenceCalculator(0);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 0L, 0);
        AppointmentBugTests.assertEquals((String)("Unexpected number of occurrences: " + rss.size() + ". Should be: " + 4), (int)4, (int)rss.size());
    }

    public void testBug9823() throws Exception {
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug9823");
        cdao.setIgnoreConflicts(true);
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1193011200000L));
        cdao.setEndDate(new Date(1193270400000L));
        cdao.setRecurrenceCalculator(3);
        cdao.setRecurrenceType(1);
        cdao.setInterval(7);
        cdao.setOccurrence(2);
        cdao.setFullTime(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Object was created", (object_id > 0 ? 1 : 0) != 0);
        RecurringResultsInterface rss = new CalendarCollection().calculateRecurring((CalendarObject)cdao, 1193176800000L, 1193263200000L, 0);
        AppointmentBugTests.assertEquals((String)("Unexpected number of occurrences: " + rss.size() + ". Should be: " + 1), (int)1, (int)rss.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug11719() throws Exception {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"testBug11719");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug11719");
        cdao.setIgnoreConflicts(true);
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1217203200000L));
        cdao.setEndDate(new Date(1217289600000L));
        cdao.setFullTime(true);
        cdao.setRecurrenceCalculator(1);
        cdao.setRecurrenceType(1);
        cdao.setInterval(1);
        cdao.setUntil(new Date(1217721600000L));
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Object was not created", (object_id > 0 ? 1 : 0) != 0);
        try {
            CalendarDataObject edao = csql.getObjectById(object_id, fid);
            AppointmentBugTests.assertTrue((String)"Loading from storage failed", (edao != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Unexpected start time in first occurrence", (long)1217203200000L, (long)edao.getStartDate().getTime());
            AppointmentBugTests.assertEquals((String)"Unexpected end time in first occurrence", (long)1217289600000L, (long)edao.getEndDate().getTime());
            RecurringResultsInterface rrs = new CalendarCollection().calculateRecurring((CalendarObject)edao, 0L, 0L, 0, 999, true);
            RecurringResultInterface rr = rrs.getRecurringResultByPosition(rrs.size());
            AppointmentBugTests.assertTrue((String)"Calculated last occurrence is null", (rr != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Unexpected last occurrence's start time: ", (long)1217721600000L, (long)rr.getStart());
            AppointmentBugTests.assertEquals((String)"Unexpected last occurrence's end time: ", (long)1217808000000L, (long)rr.getEnd());
        }
        finally {
            this.hardDelete(object_id, (Context)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug11695() throws Exception {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"testBug11695");
        int fid = AppointmentBugTests.getPrivateFolder(userid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testBug11695");
        cdao.setIgnoreConflicts(true);
        cdao.setTimezone(TIMEZONE);
        cdao.setStartDate(new Date(1222084800000L));
        cdao.setEndDate(new Date(1222088400000L));
        cdao.setFullTime(false);
        cdao.setRecurrenceCalculator(0);
        cdao.setRecurrenceType(2);
        cdao.setInterval(1);
        cdao.setDays(62);
        cdao.setUntil(new Date(1222646400000L));
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        AppointmentBugTests.assertTrue((String)"Object was not created", (object_id > 0 ? 1 : 0) != 0);
        try {
            CalendarDataObject edao = csql.getObjectById(object_id, fid);
            AppointmentBugTests.assertTrue((String)"Loading from storage failed", (edao != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Unexpected start time in first occurrence", (long)1222084800000L, (long)edao.getStartDate().getTime());
            AppointmentBugTests.assertEquals((String)"Unexpected end time in first occurrence", (long)1222088400000L, (long)edao.getEndDate().getTime());
            RecurringResultsInterface rrs = new CalendarCollection().calculateRecurring((CalendarObject)edao, 0L, 0L, 0, 999, true);
            AppointmentBugTests.assertTrue((String)"Calculating recurrence failed", (rrs != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Unexpected number of occurrences: ", (int)6, (int)rrs.size());
            RecurringResultInterface rr = rrs.getRecurringResultByPosition(rrs.size());
            AppointmentBugTests.assertTrue((String)"Calculated last occurrence is null", (rr != null ? 1 : 0) != 0);
            AppointmentBugTests.assertEquals((String)"Unexpected last occurrence's start time: ", (long)1222689600000L, (long)rr.getStart());
            AppointmentBugTests.assertEquals((String)"Unexpected last occurrence's end time: ", (long)1222693200000L, (long)rr.getEnd());
        }
        finally {
            this.hardDelete(object_id, (Context)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBug11881() throws Exception {
        ContextImpl context = new ContextImpl(contextid);
        int object_id = -1;
        try {
            SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
            int fid = AppointmentBugTests.getPrivateFolder(userid);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(fid);
            cdao.setTitle("testBug11881");
            cdao.setIgnoreConflicts(true);
            CalendarTest.fillDatesInDao(cdao);
            Participants participants = new Participants();
            String user2 = AbstractConfigWrapper.parseProperty((Properties)AppointmentBugTests.getAJAXProperties(), (String)"user_participant3", (String)"");
            int userid2 = AppointmentBugTests.resolveUser(user2);
            UserParticipant p1 = new UserParticipant(userid);
            participants.add((Participant)p1);
            UserParticipant p2 = new UserParticipant(userid2);
            participants.add((Participant)p2);
            cdao.setParticipants(participants.getList());
            CalendarSql csql = new CalendarSql((Session)so);
            csql.insertAppointmentObject(cdao);
            object_id = cdao.getObjectID();
            AppointmentBugTests.assertTrue((String)"Object creation failed", (object_id > 0 ? 1 : 0) != 0);
            CalendarDataObject update = new CalendarDataObject();
            update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update.setIgnoreConflicts(true);
            update.setObjectID(object_id);
            update.setTitle("testBug11881 - step 2");
            update.setPrivateFlag(true);
            try {
                csql.updateAppointmentObject(update, fid, new Date());
                AppointmentBugTests.fail((String)"Update successfull although private appointment contains multiple participants");
            }
            catch (OXException e) {
                AppointmentBugTests.assertTrue((boolean)e.similarTo((OXExceptionCode)OXCalendarExceptionCodes.PRIVATE_FLAG_AND_PARTICIPANTS));
            }
        }
        finally {
            if (object_id != -1) {
                this.hardDelete(object_id, (Context)context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBug12045() throws Exception {
        int object_id = -1;
        try {
            SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)AppointmentBugTests.getContext().getContextId(), (String)"myTestSearch");
            int fid = AppointmentBugTests.getPrivateFolder(userid);
            long l = System.currentTimeMillis();
            long start = l = l - l % 3600000L + 3600000L;
            long end = start + 3600000L;
            CalendarSql csql = new CalendarSql((Session)so);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(fid);
            cdao.setTitle("testBug12045");
            cdao.setIgnoreConflicts(true);
            cdao.setStartDate(new Date(start));
            cdao.setEndDate(new Date(end));
            cdao.setFullTime(false);
            cdao.setShownAs(1);
            cdao.setAlarm(15);
            cdao.setNotification(true);
            cdao.setRecurrenceType(1);
            cdao.setInterval(1);
            cdao.setOccurrence(3);
            csql.insertAppointmentObject(cdao);
            object_id = cdao.getObjectID();
            AppointmentBugTests.assertTrue((String)"Object creation failed", (object_id > 0 ? 1 : 0) != 0);
            ReminderObject ro = new ReminderHandler(AppointmentBugTests.getContext()).loadReminder(object_id, userid, 1);
            AppointmentBugTests.assertTrue((String)"Folder ID mismatch in reminder", (ro.getFolder() == fid ? 1 : 0) != 0);
            int reminderId = ro.getObjectId();
            OXFolderManager folderManager = OXFolderManager.getInstance((Session)so);
            FolderObject fo = new FolderObject();
            fo.setFolderName("TestFolder-testBug12045-" + String.valueOf(System.currentTimeMillis()));
            fo.setParentFolderID(fid);
            fo.setModule(2);
            fo.setType(1);
            OCLPermission p = new OCLPermission(userid, fid);
            p.setFolderAdmin(true);
            p.setAllPermission(128, 128, 128, 128);
            fo.setPermissionsAsArray(new OCLPermission[]{p});
            folderManager.createFolder(fo, true, System.currentTimeMillis());
            AppointmentBugTests.assertTrue((String)"Folder creation failed", (fo.getObjectID() > 0 ? 1 : 0) != 0);
            try {
                CalendarDataObject update = new CalendarDataObject();
                update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
                update.setIgnoreConflicts(true);
                update.setObjectID(object_id);
                update.setTitle("testBug12045 - step 2");
                update.setStartDate(new Date(start));
                update.setEndDate(new Date(end));
                update.setNotification(true);
                update.setParentFolderID(fo.getObjectID());
                csql.updateAppointmentObject(update, fid, new Date());
                ReminderObject ro2 = new ReminderHandler(AppointmentBugTests.getContext()).loadReminder(reminderId);
                AppointmentBugTests.assertTrue((String)"Reminder's folder ID not updated properly", (ro2.getFolder() == fo.getObjectID() ? 1 : 0) != 0);
            }
            finally {
                try {
                    new ReminderHandler(AppointmentBugTests.getContext()).deleteReminder(object_id, userid, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    folderManager.deleteFolder(fo, true, System.currentTimeMillis());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (object_id != -1) {
                this.hardDelete(object_id, AppointmentBugTests.getContext());
            }
        }
    }
}

