/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class AlarmTestIOSCalendar
extends CalDAVTest {
    @Override
    protected String getDefaultUserAgent() {
        return "iOS/9.1 (13B143) dataaccessd/1.0";
    }

    @Test
    public void testAcknowledgeReminder() throws Exception {
        String uid = AlarmTestIOSCalendar.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Dem\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "TRIGGER:-PT15M\r\n" + "UID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "X-WR-ALARMUID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date acknowledgedDate = TimeTools.D("next sunday at 15:47:32");
        iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Dem\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:3C9EBB4D-8AA0-4B37-B3BB-9EEF8C70F2B0\r\n" + "X-WR-ALARMUID:3C9EBB4D-8AA0-4B37-B3BB-9EEF8C70F2B0\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertFalse((String)"reminder still found", (boolean)appointment.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        AlarmTestIOSCalendar.assertDummyAlarm(iCalResource.getVEvent());
    }

    @Test
    public void testSnoozeReminder() throws Exception {
        String uid = AlarmTestIOSCalendar.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Dem\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "TRIGGER:-PT15M\r\n" + "UID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "X-WR-ALARMUID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("next sunday at 15:47"));
        calendar.add(13, 32);
        Date acknowledgedDate = calendar.getTime();
        calendar.add(12, 5);
        Date nextTrigger = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Dem\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "RELATED-TO:429D8792-FA4F-4D60-837F-FF673662ADF3\r\n" + "TRIGGER:-PT7M28S\r\n" + "UID:48DA570F-2E00-46BD-9CCA-A92D44E07AD8\r\n" + "X-WR-ALARMUID:48DA570F-2E00-46BD-9CCA-A92D44E07AD8\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:429D8792-FA4F-4D60-837F-FF673662ADF3\r\n" + "X-WR-ALARMUID:429D8792-FA4F-4D60-837F-FF673662ADF3\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        for (SimpleICal.Component vAlarm : vAlarms) {
            if (null != vAlarm.getProperty("RELATED-TO")) {
                Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(nextTrigger), (Object)vAlarm.getPropertyValue("TRIGGER"));
                continue;
            }
            Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarm.getPropertyValue("TRIGGER"));
        }
    }

    @Test
    public void testEditReminder() throws Exception {
        String uid = AlarmTestIOSCalendar.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Dem\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "TRIGGER:-PT15M\r\n" + "UID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "X-WR-ALARMUID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date initialAcknowledged = TimeTools.D("next sunday at 15:44");
        iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Dem\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "DESCRIPTION:Erinnerung\r\n" + "TRIGGER:-PT20M\r\n" + "UID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "X-WR-ALARMUID:71926843-FB96-440E-B84F-0185F967096D\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)20L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT20M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    @Test
    public void testAcknowledgeRecurringReminder() throws Exception {
        String uid = AlarmTestIOSCalendar.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "TRIGGER:-PT15M\r\n" + "UID:016232FB-1CA9-4657-99F7-51052C884495\r\n" + "X-WR-ALARMUID:016232FB-1CA9-4657-99F7-51052C884495\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(initialAcknowledged);
        calendar.add(5, 1);
        Date nextAcknowledged = calendar.getTime();
        calendar.setTime(initialAcknowledged);
        calendar.add(12, 3);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "X-MOZ-LASTACK:" + AlarmTestIOSCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:F7FCDC9A-BA2A-4548-BC5A-815008F0FC6E\r\n" + "X-WR-ALARMUID:F7FCDC9A-BA2A-4548-BC5A-815008F0FC6E\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(nextAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
    }

    @Test
    public void testSnoozeRecurringReminder() throws Exception {
        String uid = AlarmTestIOSCalendar.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        calendar.add(12, -16);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "TRIGGER:-PT15M\r\n" + "UID:016232FB-1CA9-4657-99F7-51052C884495\r\n" + "X-WR-ALARMUID:016232FB-1CA9-4657-99F7-51052C884495\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(start);
        calendar.add(5, 2);
        calendar.add(12, -14);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        calendar.add(12, 5);
        calendar.add(12, -1);
        Date nextAcknowledged = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "X-MOZ-LASTACK:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:F7FCDC9A-BA2A-4548-BC5A-815008F0FC6E\r\n" + "X-WR-ALARMUID:F7FCDC9A-BA2A-4548-BC5A-815008F0FC6E\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "RELATED-TO:F7FCDC9A-BA2A-4548-BC5A-815008F0FC6E\r\n" + "TRIGGER:-PT8M43S\r\n" + "UID:48DA570F-2E00-46BD-9CCA-A92D44E07AD8\r\n" + "X-WR-ALARMUID:48DA570F-2E00-46BD-9CCA-A92D44E07AD8\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(nextAcknowledged), (Object)vAlarms.get(0).getPropertyValue("ACKNOWLEDGED"));
        Assert.assertNotNull((String)"No RELATED-TO found", (Object)vAlarms.get(1).getProperty("RELATED-TO"));
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT8M43S", (Object)vAlarms.get(1).getPropertyValue("TRIGGER"));
    }

    @Test
    public void testAcknowledgeExceptionReminder() throws Exception {
        String uid = AlarmTestIOSCalendar.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "X-MOZ-LASTACK:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "X-WR-ALARMUID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:SerieEdit\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "X-WR-ALARMUID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"SerieEdit", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 52);
        Date exceptionAcknowledged = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "X-MOZ-LASTACK:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "X-WR-ALARMUID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:SerieEdit\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(exceptionAcknowledged) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "X-WR-ALARMUID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertFalse((String)"reminder still found", (boolean)changeExcpetion.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"SerieEdit", (Object)iCalResource.getVEvents().get(1).getSummary());
        AlarmTestIOSCalendar.assertDummyAlarm(iCalResource.getVEvents().get(1));
    }

    @Test
    public void testSnoozeExceptionReminder() throws Exception {
        String uid = AlarmTestIOSCalendar.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "X-MOZ-LASTACK:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "X-WR-ALARMUID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:SerieEdit\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "X-WR-ALARMUID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"SerieEdit", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 52);
        Date exceptionAcknowledged = calendar.getTime();
        calendar.add(12, 9);
        Date nextTrigger = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCLASS:PUBLIC\r\nCREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:Serie\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "X-MOZ-LASTACK:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "X-WR-ALARMUID:AD79E8D2-9D87-4281-BADB-D14C069C463F\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + AlarmTestIOSCalendar.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID;TZID=Europe/Berlin:" + AlarmTestIOSCalendar.format(start, "Europe/Berlin") + "\r\n" + "SEQUENCE:0\r\n" + "SUMMARY:SerieEdit\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "BEGIN:VALARM\r\n" + "ACKNOWLEDGED:" + AlarmTestIOSCalendar.formatAsUTC(exceptionAcknowledged) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "X-WR-ALARMUID:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Erinnerung\r\n" + "RELATED-TO:AFB070AC-B007-488C-8AAA-0A5F9EE48CBC\r\n" + "TRIGGER:-PT4M08S\r\n" + "UID:48DA570F-2E00-46BD-9CCA-A92D44E07AD8\r\n" + "X-WR-ALARMUID:48DA570F-2E00-46BD-9CCA-A92D44E07AD8\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertTrue((String)"no reminder found", (boolean)changeExcpetion.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"SerieEdit", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvents().get(1).getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        for (SimpleICal.Component vAlarm : vAlarms) {
            if (null != vAlarm.getProperty("RELATED-TO")) {
                Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestIOSCalendar.formatAsUTC(nextTrigger), (Object)vAlarm.getPropertyValue("TRIGGER"));
                continue;
            }
            Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarm.getPropertyValue("TRIGGER"));
        }
    }
}

