/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug43297Test
extends CalDAVTest {
    private CalendarTestManager manager2;
    private FolderObject subfolder;
    private String sharedFolderID;

    @Override
    protected String getDefaultUserAgent() {
        return "iOS/9.1 (13B143) dataaccessd/1.0";
    }

    @Before
    public void setUp() throws Exception {
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
        FolderObject calendarFolder = this.manager2.getClient().execute(new GetRequest((API)EnumAPI.OX_NEW, this.manager2.getPrivateFolder())).getFolder();
        String subFolderName = "testfolder_" + Bug43297Test.randomUID();
        FolderObject folder = new FolderObject();
        folder.setFolderName(subFolderName);
        folder.setParentFolderID(calendarFolder.getObjectID());
        folder.setModule(calendarFolder.getModule());
        folder.setType(calendarFolder.getType());
        OCLPermission perm = new OCLPermission();
        perm.setEntity(this.getClient().getValues().getUserId());
        perm.setGroupPermission(false);
        perm.setAllPermission(8, 4, 4, 4);
        List permissions = calendarFolder.getPermissions();
        permissions.add(perm);
        folder.setPermissions(calendarFolder.getPermissions());
        InsertResponse response = this.manager2.getClient().execute(new InsertRequest((API)EnumAPI.OX_NEW, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        this.subfolder = folder;
        this.sharedFolderID = String.valueOf(folder.getObjectID());
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.manager2) {
            if (null != this.subfolder) {
                this.manager2.getClient().execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.subfolder));
            }
            this.manager2.cleanUp();
            if (null != this.manager2.getClient()) {
                this.manager2.getClient().logout();
            }
        }
    }

    @Test
    public void testDefaultAlarmInSharedFolder() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken(this.sharedFolderID));
        String uid = Bug43297Test.randomUID();
        String summary = "test alarm";
        String location = "achtung";
        Date start = TimeTools.D("next friday at 11:30");
        Date end = TimeTools.D("next friday at 12:45");
        Appointment appointment = Bug43297Test.generateAppointment(start, end, uid, summary, location);
        appointment.setAlarm(15);
        appointment.setAlarmFlag(true);
        appointment.setParentFolderID(Integer.parseInt(this.sharedFolderID));
        appointment.setIgnoreConflicts(true);
        appointment = this.manager2.insert(appointment);
        Map<String, String> eTags = this.syncCollection(syncToken, this.sharedFolderID).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug43297Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        SimpleICal.Component vAlarm = iCalResource.getVEvent().getVAlarm();
        Assert.assertNotNull((String)"No VALARM found", (Object)vAlarm);
        Assert.assertEquals((String)"Unexpected ACTION in alarm", (Object)"NONE", (Object)vAlarm.getPropertyValue("ACTION"));
        Assert.assertEquals((Object)"TRUE", (Object)vAlarm.getPropertyValue("X-APPLE-DEFAULT-ALARM"));
    }
}

