/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.groupware.container.FolderObject;
import java.util.HashMap;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.junit.Assert;
import org.junit.Test;

public class Bug37887Test
extends CalDAVTest {
    @Test
    public void testCalendarColor() throws Exception {
        String color;
        int folderID = Integer.parseInt(this.getDefaultFolderID());
        GetResponse getResponse = this.getClient().execute(new GetRequest((API)EnumAPI.OX_NEW, folderID));
        FolderObject folder = getResponse.getFolder();
        if (null == folder.getMeta() || !folder.getMeta().containsKey("color")) {
            HashMap<String, String> meta = folder.getMeta();
            meta = null == meta ? new HashMap<String, String>() : new HashMap(meta);
            color = "#000000FF";
            FolderObject toUpdate = new FolderObject(folderID);
            toUpdate.setLastModified(getResponse.getTimestamp());
            meta.put("color", color);
            toUpdate.setMeta(meta);
            this.getClient().execute(new UpdateRequest((API)EnumAPI.OX_NEW, toUpdate)).getResponse();
        } else {
            color = String.valueOf(folder.getMeta().get("color"));
        }
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.CALENDAR_COLOR);
        PropFindMethod propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 1);
        MultiStatusResponse[] responses = this.getWebDAVClient().doPropFind(propFind);
        Assert.assertNotNull((String)"got no response", (Object)responses);
        Assert.assertTrue((String)"got no responses", (0 < responses.length ? 1 : 0) != 0);
        Boolean found = null;
        for (MultiStatusResponse response : responses) {
            if ("/caldav/".equals(response.getHref()) || "/caldav/schedule-inbox/".equals(response.getHref()) || "/caldav/schedule-outbox/".equals(response.getHref())) continue;
            if (response.getProperties(200).contains(PropertyNames.CALENDAR_COLOR)) {
                if (null == found) {
                    found = Boolean.TRUE;
                    continue;
                }
                Assert.assertTrue((String)"calendar-color with both status 200 and 404", (boolean)found);
                continue;
            }
            if (!response.getProperties(404).contains(PropertyNames.CALENDAR_COLOR)) continue;
            if (null == found) {
                found = Boolean.FALSE;
                continue;
            }
            Assert.assertFalse((String)"calendar-color with both status 200 and 404", (boolean)found);
        }
    }
}

