/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug28734Test
extends CalDAVTest {
    @Test
    public void testTimeZoneHongKong() throws Exception {
        String uid = Bug28734Test.randomUID();
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle(this.getClass().getCanonicalName());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(TimeTools.D("september on friday at 20:00", TimeZone.getTimeZone("Asia/Hong_Kong")));
        appointment.setEndDate(TimeTools.D("september on friday at 21:00", TimeZone.getTimeZone("Asia/Hong_Kong")));
        appointment.setTimezone("Asia/Hong_Kong");
        super.create(appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertTrue((String)"DTSTART wrong", (boolean)iCalResource.getVEvent().getPropertyValue("DTSTART").endsWith("T200000"));
        Assert.assertTrue((String)"DTEND wrong", (boolean)iCalResource.getVEvent().getPropertyValue("DTEND").endsWith("T210000"));
    }
}

