/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug23067Test
extends CalDAVTest {
    @Test
    public void testAcceptImportedAppointment() throws Exception {
        String uid = Bug23067Test.randomUID();
        Date start = TimeTools.D("next thursday at 17:15");
        Date end = TimeTools.D("next thursday at 18:45");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Berlin:" + Bug23067Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "ORGANIZER;CN=\"horst\":MAILTO:horst@example.com" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug23067Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:loc" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:test accept" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug23067Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug23067Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "ATTENDEE;CN=\"External Super Dietmar\";CUTYPE=INDIVIDUAL;ROLE=REQ-PARTICIP" + "\r\n" + " ANT:MAILTO:superdietma@example.com" + "\r\n" + "ATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION:MAILTO:" + super.getAJAXClient().getValues().getDefaultAddress() + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        List<SimpleICal.Property> attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        block0: for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            for (Map.Entry<String, String> attribute : property.getAttributes().entrySet()) {
                if (!attribute.getKey().equals("PARTSTAT")) continue;
                attribute.setValue("ACCEPTED");
                break block0;
            }
        }
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        UserParticipant[] users = appointment.getUsers();
        Assert.assertNotNull((String)"appointment has no users", (Object)users);
        UserParticipant partipant = null;
        for (UserParticipant user : users) {
            if (this.getAJAXClient().getValues().getUserId() != user.getIdentifier()) continue;
            partipant = user;
            break;
        }
        Assert.assertNotNull((String)"accepting participant not found", partipant);
        Assert.assertEquals((String)"confirmation status wrong", (long)1L, (long)partipant.getConfirm());
        iCalResource = super.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        SimpleICal.Property attendee = null;
        attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            attendee = property;
            break;
        }
        Assert.assertNotNull((String)"accepting attendee not found", attendee);
        Assert.assertEquals((String)"partstat status wrong", (Object)"ACCEPTED", (Object)attendee.getAttribute("PARTSTAT"));
    }
}

