/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class Bug22723Test
extends CalDAVTest {
    @Test
    public void testSynchronizeDeletion() throws Exception {
        String subFolderName = "testfolder_" + Bug22723Test.randomUID();
        FolderObject subFolder = super.createFolder(subFolderName);
        super.rememberForCleanUp(subFolder);
        String subFolderID = Integer.toString(subFolder.getObjectID());
        SyncToken syncToken = new SyncToken(super.fetchSyncToken(subFolderID));
        String uid = Bug22723Test.randomUID();
        String summary = "hello";
        String location = "here";
        Date start = TimeTools.D("tomorrow at 6am");
        Date end = TimeTools.D("tomorrow at 8am");
        String iCal = Bug22723Test.generateICal(start, end, uid, summary, location);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(subFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(subFolderID, uid);
        super.rememberForCleanUp(appointment);
        Bug22723Test.assertAppointmentEquals(appointment, start, end, uid, summary, location);
        super.delete(appointment);
        Assert.assertNull((String)"Appointment not deleted on server", (Object)super.getAppointment(subFolderID, uid));
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken, subFolderID);
        Assert.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        boolean found = false;
        for (String href : syncCollectionResponse.getHrefsStatusNotFound()) {
            if (null == href || !href.contains(uid)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"appointment not reported as deleted", (boolean)found);
    }
}

