/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug22451Test
extends CalDAVTest {
    @Test
    public void testUntilDate() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("3 days after midnight", TimeZone.getTimeZone("UTC")));
        Date serverUntil = calendar.getTime();
        calendar.setTime(TimeTools.D("Tomorrow at midnight", TimeZone.getTimeZone("Europe/Berlin")));
        for (int i = 0; i < 24; ++i) {
            Appointment appointment = new Appointment();
            appointment.setUid(Bug22451Test.randomUID());
            appointment.setTitle("Series " + i);
            appointment.setIgnoreConflicts(true);
            appointment.setStartDate(calendar.getTime());
            calendar.add(11, 1);
            appointment.setEndDate(calendar.getTime());
            appointment.setRecurrenceType(1);
            appointment.setInterval(1);
            appointment.setUntil(serverUntil);
            super.create(appointment);
            appointments.add(appointment);
        }
        Date clientLastModified = this.getManager().getLastModification();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar userCalendar = Calendar.getInstance(this.getClient().getValues().getTimeZone());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            ICalResource iCalResource = Bug22451Test.assertContains(appointment.getUid(), calendarData);
            Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Assert.assertEquals((String)"SUMMARY wrong", (Object)appointment.getTitle(), (Object)iCalResource.getVEvent().getSummary());
            Assert.assertEquals((String)"DTSTART wrong", (Object)appointment.getStartDate(), (Object)iCalResource.getVEvent().getDTStart());
            Assert.assertEquals((String)"DTEND wrong", (Object)appointment.getEndDate(), (Object)iCalResource.getVEvent().getDTEnd());
            SimpleICal.Property rruleProperty = iCalResource.getVEvent().getProperty("RRULE");
            Assert.assertNotNull((String)"RRULE not found", (Object)rruleProperty);
            int startIndex = rruleProperty.getValue().indexOf("UNTIL=") + 6;
            int endIndex = rruleProperty.getValue().indexOf(";", startIndex);
            String iCalUntil = 0 < endIndex ? rruleProperty.getValue().substring(startIndex, endIndex) : rruleProperty.getValue().substring(startIndex);
            userCalendar.setTime(dateFormat.parse(iCalUntil));
            calendar.setTime(appointment.getUntil());
            Assert.assertEquals((String)"UNTIL date wrong", (long)calendar.get(5), (long)userCalendar.get(5));
        }
        for (ICalResource iCalResource : calendarData) {
            iCalResource.getVEvent().setSummary(iCalResource.getVEvent().getSummary() + "_edit");
            Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        }
        List<Appointment> updates = super.getManager().updates(Bug22451Test.parse(this.getDefaultFolderID()), clientLastModified, false);
        Assert.assertNotNull((String)"no updates found on server", updates);
        Assert.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        for (Appointment appointment : appointments) {
            Appointment updatedAppointment = null;
            for (Appointment update : updates) {
                if (appointment.getObjectID() != update.getObjectID()) continue;
                updatedAppointment = update;
                break;
            }
            Assert.assertNotNull((String)"Exception not found", updatedAppointment);
            Assert.assertEquals((String)"Title wrong", (Object)(appointment.getTitle() + "_edit"), (Object)updatedAppointment.getTitle());
            Assert.assertEquals((String)"Until date wrong", (Object)appointment.getUntil(), (Object)updatedAppointment.getUntil());
        }
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            ICalResource iCalResource = Bug22451Test.assertContains(appointment.getUid(), calendarData);
            Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Assert.assertEquals((String)"SUMMARY wrong", (Object)(appointment.getTitle() + "_edit"), (Object)iCalResource.getVEvent().getSummary());
            SimpleICal.Property rruleProperty = iCalResource.getVEvent().getProperty("RRULE");
            Assert.assertNotNull((String)"RRULE not found", (Object)rruleProperty);
            int startIndex = rruleProperty.getValue().indexOf("UNTIL=") + 6;
            int endIndex = rruleProperty.getValue().indexOf(";", startIndex);
            String iCalUntil = 0 < endIndex ? rruleProperty.getValue().substring(startIndex, endIndex) : rruleProperty.getValue().substring(startIndex);
            userCalendar.setTime(dateFormat.parse(iCalUntil));
            calendar.setTime(appointment.getUntil());
            Assert.assertEquals((String)"UNTIL date wrong", (long)calendar.get(5), (long)userCalendar.get(5));
        }
    }
}

