/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.contact.internal.Tools;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug22338Test
extends CalDAVTest {
    @Test
    public void testLastModified() throws Exception {
        String uid = Bug22338Test.randomUID();
        String summary = "bug 22338";
        String location = "test";
        Date start = TimeTools.D("tomorrow at 2pm");
        Date end = TimeTools.D("tomorrow at 8pm");
        String iCal = Bug22338Test.generateICal(start, end, uid, summary, location);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        Bug22338Test.assertAppointmentEquals(appointment, start, end, uid, summary, location);
        Date clientLastModified = super.getManager().getLastModification();
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        Assert.assertEquals((String)"DTSTART wrong", (Object)start, (Object)iCalResource.getVEvent().getDTStart());
        Assert.assertEquals((String)"DTEND wrong", (Object)end, (Object)iCalResource.getVEvent().getDTEnd());
        Date updatedStart = TimeTools.D("tomorrow at 4pm");
        Date updatedEnd = TimeTools.D("tomorrow at 10pm");
        iCalResource.getVEvent().setDTStart(updatedStart);
        iCalResource.getVEvent().setDTEnd(updatedEnd);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        List<Appointment> updates = super.getManager().updates(Tools.parse((String)this.getDefaultFolderID()), clientLastModified, false);
        Assert.assertNotNull((String)"appointment not found on server", updates);
        Assert.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        Appointment updatedAppointment = null;
        for (Appointment update : updates) {
            if (!uid.equals(update.getUid())) continue;
            updatedAppointment = update;
            break;
        }
        Assert.assertNotNull((String)"appointment not listed in updates", updatedAppointment);
        Bug22338Test.assertAppointmentEquals(updatedAppointment, updatedStart, updatedEnd, uid, summary, location);
        Assert.assertTrue((String)"last modified not changed", (boolean)clientLastModified.before(super.getManager().getLastModification()));
    }
}

