/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.configuration.TestConfig;
import com.openexchange.exception.OXException;
import com.openexchange.tools.conf.AbstractConfig;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class MailConfig
extends AbstractConfig {
    private static final TestConfig.Property KEY = TestConfig.Property.MAIL_PROPS;
    private static final Lock LOCK_INIT = new ReentrantLock();
    private static boolean initialized;
    private static MailConfig singleton;

    protected String getPropertyFileName() throws OXException {
        String fileName = TestConfig.getProperty(KEY);
        if (null == fileName) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{KEY.getPropertyName()});
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws OXException {
        TestConfig.init();
        if (!initialized) {
            LOCK_INIT.lock();
            try {
                if (null == singleton) {
                    singleton = new MailConfig();
                    singleton.loadPropertiesInternal();
                }
            }
            finally {
                LOCK_INIT.unlock();
            }
        }
    }

    public static String getProperty(Property key) {
        if (!initialized) {
            try {
                MailConfig.init();
            }
            catch (OXException e) {
                return null;
            }
        }
        return singleton.getPropertyInternal(key.getPropertyName());
    }

    public static enum Property {
        SERVER("server"),
        PORT("port"),
        LOGIN("login"),
        LOGIN2("login2"),
        LOGIN3("login3"),
        PASSWORD("password"),
        USER("user"),
        CONTEXT("cid"),
        TEST_MAIL_DIR("testMailDir"),
        SECOND_USER("seconduser");

        private String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

