/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.user.actions.GetAttributeRequest;
import com.openexchange.ajax.user.actions.GetAttributeResponse;
import com.openexchange.ajax.user.actions.SetAttributeRequest;
import com.openexchange.ajax.user.actions.SetAttributeResponse;
import com.openexchange.tools.RandomString;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug26431Test
extends AbstractAJAXSession {
    private static final String ATTRIBUTE_NAME = "testForBug26431";
    private AJAXClient client;
    private int userId;

    public Bug26431Test(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.userId = this.client.getValues().getUserId();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testOmittedValue() throws Exception {
        String value = RandomString.generateChars(64);
        SetAttributeResponse response = this.client.execute(new SetAttributeRequest(this.userId, ATTRIBUTE_NAME, value, false));
        Bug26431Test.assertTrue((String)"Setting a test attribute failed.", (boolean)response.isSuccess());
        response = this.client.execute(new SetAttributeRequest(this.userId, ATTRIBUTE_NAME, null, false));
        Bug26431Test.assertTrue((String)"Removing the attribute failed.", (boolean)response.isSuccess());
        GetAttributeResponse response2 = this.client.execute(new GetAttributeRequest(this.userId, ATTRIBUTE_NAME));
        Bug26431Test.assertNull((String)"Removing the attribute failed.", (Object)response2.getValue());
    }

    @Test
    public void testNullValue() throws Exception {
        String value = RandomString.generateChars(64);
        SetAttributeResponse response = this.client.execute(new SetAttributeRequest(this.userId, ATTRIBUTE_NAME, value, false));
        Bug26431Test.assertTrue((String)"Setting a test attribute failed.", (boolean)response.isSuccess());
        response = this.client.execute(new SetAttributeRequest(this.userId, ATTRIBUTE_NAME, JSONObject.NULL, false));
        Bug26431Test.assertTrue((String)"Removing the attribute failed.", (boolean)response.isSuccess());
        GetAttributeResponse response2 = this.client.execute(new GetAttributeRequest(this.userId, ATTRIBUTE_NAME));
        Bug26431Test.assertNull((String)"Removing the attribute failed.", (Object)response2.getValue());
    }
}

