/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.task.actions.AbstractTaskRequest;
import com.openexchange.ajax.task.actions.UpdateParser;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateRequest
extends AbstractTaskRequest<UpdateResponse> {
    private final int folderId;
    private final boolean removeFolderId;
    private final Task task;
    private final TimeZone timeZone;
    private final boolean failOnError;
    private final boolean useLegacyDates;

    public UpdateRequest(Task task, TimeZone timeZone) {
        this(task.getParentFolderID(), true, task, timeZone);
    }

    public UpdateRequest(Task task, TimeZone timeZone, boolean failOnError) {
        this(task.getParentFolderID(), true, task, timeZone, failOnError);
    }

    public UpdateRequest(Task task, TimeZone timeZone, boolean failOnError, boolean useLegacyDates) {
        this(task.getParentFolderID(), true, task, timeZone, failOnError, useLegacyDates);
    }

    public UpdateRequest(int folderId, Task task, TimeZone timeZone) {
        this(folderId, false, task, timeZone);
    }

    public UpdateRequest(int folderId, Task task, TimeZone timeZone, boolean failOnError) {
        this(folderId, false, task, timeZone, failOnError);
    }

    private UpdateRequest(int folderId, boolean removeFolderId, Task task, TimeZone timeZone) {
        this(folderId, removeFolderId, task, timeZone, true);
    }

    private UpdateRequest(int folderId, boolean removeFolderId, Task task, TimeZone timeZone, boolean failOnError) {
        this(folderId, removeFolderId, task, timeZone, failOnError, true);
    }

    private UpdateRequest(int folderId, boolean removeFolderId, Task task, TimeZone timeZone, boolean failOnError, boolean useLegacyDates) {
        this.folderId = folderId;
        this.removeFolderId = removeFolderId;
        this.task = task;
        this.timeZone = timeZone;
        this.failOnError = failOnError;
        this.useLegacyDates = useLegacyDates;
    }

    public JSONObject getBody() throws JSONException {
        JSONObject json;
        JSONObject jSONObject = json = this.useLegacyDates ? this.convert(this.task, this.timeZone) : this.convertNew(this.task, this.timeZone);
        if (this.removeFolderId) {
            json.remove("folder_id");
        }
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "update"), new AJAXRequest.Parameter("folder", this.folderId), new AJAXRequest.Parameter("id", this.task.getObjectID()), new AJAXRequest.Parameter("timestamp", this.task.getLastModified().getTime())};
    }

    public UpdateParser getParser() {
        return new UpdateParser(this.failOnError);
    }

    protected Task getTask() {
        return this.task;
    }
}

