/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.task.actions.AbstractTaskRequest;
import com.openexchange.ajax.task.actions.SearchParser;
import com.openexchange.ajax.task.actions.SearchResponse;
import com.openexchange.ajax.task.actions.TaskSearchJSONWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchRequest
extends AbstractTaskRequest<SearchResponse> {
    final TaskSearchObject search;
    final int[] columns;
    final int sort;
    final Order order;
    final boolean failOnError;

    public SearchRequest(TaskSearchObject search, int[] columns) {
        this(search, columns, true);
    }

    public SearchRequest(TaskSearchObject search, int[] columns, boolean failOnError) {
        this(search, columns, 0, null, failOnError);
    }

    public SearchRequest(TaskSearchObject search, int[] columns, int sort, Order order) {
        this(search, columns, sort, order, true);
    }

    public SearchRequest(TaskSearchObject search, int[] columns, int sort, Order order, boolean failOnError) {
        this.search = search;
        this.columns = AbstractTaskRequest.addGUIColumns(columns);
        this.sort = sort;
        this.order = order;
        this.failOnError = failOnError;
    }

    public JSONObject getBody() throws JSONException {
        try {
            return TaskSearchJSONWriter.write(this.search);
        }
        catch (OXException e) {
            throw new JSONException((Throwable)e);
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        Date[] range;
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "search"));
        params.add(new AJAXRequest.Parameter("columns", this.columns));
        if (null != this.order) {
            params.add(new AJAXRequest.Parameter("sort", this.sort));
            params.add(new AJAXRequest.Parameter("order", OrderFields.write((Order)this.order)));
        }
        if (null != (range = this.search.getRange()) && range.length == 2) {
            params.add(new AJAXRequest.Parameter("start", range[0]));
            params.add(new AJAXRequest.Parameter("end", range[1]));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    public SearchParser getParser() {
        return new SearchParser(this.failOnError, this.columns);
    }
}

