/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug37927Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private TimeZone timeZone;
    private List<Task> tasksToDelete;

    public Bug37927Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.tasksToDelete = new ArrayList<Task>();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        if (null != this.client && null != this.tasksToDelete) {
            int folderID = this.client.getValues().getPrivateTaskFolder();
            HashSet<Integer> ids = new HashSet<Integer>();
            for (Task task : this.tasksToDelete) {
                if (folderID != task.getParentFolderID()) {
                    this.client.execute(new DeleteRequest(task));
                    continue;
                }
                ids.add(task.getObjectID());
            }
            if (0 < ids.size()) {
                this.client.execute(new DeleteRequest(folderID, Autoboxing.I2i(ids), new Date(Long.MAX_VALUE), false));
            }
        }
        super.tearDown();
    }

    @Test
    public void testGetAllTasks() throws Exception {
        Task task1 = new Task();
        task1.setStartDate(TimeTools.D("27.03.2015 11:11", this.timeZone));
        task1.setEndDate(TimeTools.D("28.03.2015 13:00", this.timeZone));
        task1.setFullTime(false);
        task1.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task1.setTitle("testCreateWithNewClient");
        this.client.execute(new InsertRequest(task1, this.timeZone, false, true, false)).fillTask(task1);
        this.tasksToDelete.add(task1);
        Task task2 = new Task();
        task2.setStartDate(TimeTools.D("27.03.2015 12:12", this.timeZone));
        task2.setEndDate(TimeTools.D("28.03.2015 14:00", this.timeZone));
        task2.setFullTime(false);
        task2.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task2.setTitle("testCreateWithNewClient");
        this.client.execute(new InsertRequest(task2, this.timeZone, false, true, false)).fillTask(task2);
        this.tasksToDelete.add(task2);
        int[] columns = new int[]{1, 316, 317};
        CommonAllResponse allResponse = this.client.execute(new AllRequest(this.client.getValues().getPrivateTaskFolder(), columns, 316, Order.ASCENDING));
        Bug37927Test.assertFalse((String)allResponse.getErrorMessage(), (boolean)allResponse.hasError());
        allResponse = this.client.execute(new AllRequest(this.client.getValues().getPrivateTaskFolder(), columns, 317, Order.DESCENDING));
        Bug37927Test.assertFalse((String)allResponse.getErrorMessage(), (boolean)allResponse.hasError());
    }
}

