/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.group.actions.CreateRequest;
import com.openexchange.ajax.group.actions.CreateResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug15291Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private final Group group = new Group();
    private Task task;
    private TimeZone timeZone;

    public Bug15291Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.group.setSimpleName("GroupForTestingBug15291");
        this.group.setDisplayName("Group for testing bug 15291");
        Participant participant = ParticipantTools.getSomeParticipant(this.client1);
        this.group.setMember(new int[]{participant.getIdentifier()});
        CreateResponse response = this.client1.execute(new CreateRequest(this.group));
        response.fillGroup(this.group);
        this.timeZone = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.client1.getValues().getPrivateTaskFolder(), "Test for bug 15291");
        this.task.addParticipant(participant);
        this.client1.execute(new InsertRequest(this.task, this.timeZone, true)).fillTask(this.task);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.client1.execute(new DeleteRequest(this.task));
        this.client1.execute(new com.openexchange.ajax.group.actions.DeleteRequest(this.group));
        super.tearDown();
    }

    @Test
    public void testAddGroupParticipant() throws OXException, IOException, JSONException {
        Task test = Create.cloneForUpdate(this.task);
        test.addParticipant((Participant)new GroupParticipant(this.group.getIdentifier()));
        UpdateResponse response = this.client1.execute(new UpdateRequest(test, this.timeZone));
        response.fillTask(this.task, test);
        Task test2 = this.client1.execute(new GetRequest(test)).getTask(this.timeZone);
        Participant[] participants = test2.getParticipants();
        Bug15291Test.assertEquals((String)"Number of task participants should be one.", (int)1, (int)participants.length);
        Participant participant = participants[0];
        Bug15291Test.assertEquals((String)"Only participant should be the group participant.", (int)this.group.getIdentifier(), (int)participant.getIdentifier());
    }
}

