/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug14450Test
extends AbstractTaskTest {
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;
    private Task task;

    public Bug14450Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.folderId, "Bug 14450 test task");
        InsertResponse insertR = this.client.execute(new NullSendingInsertRequest(this.task, this.tz));
        insertR.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testGetRequest() throws OXException, IOException, JSONException, OXException {
        GetRequest request = new GetRequest(this.task.getParentFolderID(), this.task.getObjectID());
        GetResponse response = this.client.execute(request);
        Task toTest = response.getTask(this.tz);
        Bug14450Test.assertFalse((String)"Task contains target duration but should not.", (boolean)toTest.containsTargetDuration());
        Bug14450Test.assertEquals((String)"Target duration has wrong value.", (Object)this.task.getTargetDuration(), (Object)toTest.getTargetDuration());
        Bug14450Test.assertFalse((String)"Task contains actual duration but should not.", (boolean)toTest.containsActualDuration());
        Bug14450Test.assertEquals((String)"Actual duration has wrong value.", (Object)this.task.getActualDuration(), (Object)toTest.getActualDuration());
        Bug14450Test.assertFalse((String)"Task contains target costs but should not.", (boolean)toTest.containsTargetCosts());
        Bug14450Test.assertEquals((String)"Target costs has wrong value.", (Object)this.task.getTargetCosts(), (Object)toTest.getTargetCosts());
        Bug14450Test.assertFalse((String)"Task contains actual costs but should not.", (boolean)toTest.containsActualCosts());
        Bug14450Test.assertEquals((String)"Actual costs has wrong value.", (Object)this.task.getActualCosts(), (Object)toTest.getActualCosts());
    }

    public void testListRequest() throws OXException, IOException, JSONException {
        ListIDs ids = ListIDs.l(new int[][]{{this.task.getParentFolderID(), this.task.getObjectID()}});
        ListRequest request = new ListRequest(ids, new int[]{308, 303, 307, 302});
        CommonListResponse response = this.client.execute(request);
        Object targetDuration = response.getValue(0, 308);
        Bug14450Test.assertNull((String)"Target duration should not be set.", (Object)targetDuration);
        Object actualDuration = response.getValue(0, 303);
        Bug14450Test.assertNull((String)"Actual duration should not be set.", (Object)actualDuration);
        Object targetCosts = response.getValue(0, 307);
        Bug14450Test.assertNull((String)"Target costs should not be set.", (Object)targetCosts);
        Object actualCosts = response.getValue(0, 302);
        Bug14450Test.assertNull((String)"Actual costs should not be set.", (Object)actualCosts);
    }

    private static final class NullSendingInsertRequest
    extends InsertRequest {
        public NullSendingInsertRequest(Task task, TimeZone timeZone) {
            super(task, timeZone);
        }

        @Override
        public JSONObject getBody() throws JSONException {
            JSONObject json = super.getBody();
            json.put("target_duration", JSONObject.NULL);
            json.put("actual_duration", JSONObject.NULL);
            json.put("target_costs", JSONObject.NULL);
            json.put("actual_costs", JSONObject.NULL);
            return json;
        }
    }
}

