/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.SearchRequest;
import com.openexchange.ajax.task.actions.SearchResponse;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.impl.OCLPermission;

public class Bug11650Test
extends AbstractTaskTest {
    public Bug11650Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchInSharedFolder() throws Throwable {
        AJAXClient anton = this.getClient();
        int antonFID = anton.getValues().getPrivateTaskFolder();
        AJAXClient berta = new AJAXClient(AJAXClient.User.User2);
        FolderObject folder = Bug11650Test.createFolder(anton.getValues().getUserId(), berta.getValues().getUserId());
        folder.setParentFolderID(antonFID);
        CommonInsertResponse fResponse = anton.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, folder));
        fResponse.fillObject((DataObject)folder);
        Task task = Create.createWithDefaults();
        task.setTitle("Bug11650Test");
        task.setParentFolderID(folder.getObjectID());
        try {
            InsertResponse insert = Executor.execute(anton, new InsertRequest(task, anton.getValues().getTimeZone()));
            insert.fillTask(task);
            TaskSearchObject search = new TaskSearchObject();
            search.setPattern("*");
            search.addFolder(folder.getObjectID());
            SearchResponse response = Executor.execute(berta, new SearchRequest(search, SearchRequest.GUI_COLUMNS));
            Bug11650Test.assertFalse((String)"Searching for tasks in a shared folder failed.", (boolean)response.hasError());
        }
        finally {
            anton.execute(new DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), folder.getLastModified()));
        }
    }

    private static FolderObject createFolder(int anton, int berta) {
        FolderObject folder = new FolderObject();
        folder.setFolderName("Bug 11650 folder");
        folder.setModule(1);
        folder.setType(1);
        OCLPermission perm1 = new OCLPermission();
        perm1.setEntity(anton);
        perm1.setGroupPermission(false);
        perm1.setFolderAdmin(true);
        perm1.setAllPermission(128, 128, 128, 128);
        OCLPermission perm2 = new OCLPermission();
        perm2.setEntity(berta);
        perm2.setGroupPermission(false);
        perm2.setFolderAdmin(false);
        perm2.setAllPermission(4, 4, 4, 4);
        folder.setPermissionsAsArray(new OCLPermission[]{perm1, perm2});
        return folder;
    }
}

