/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.RecipientType;

public class ParallelGuestSessionsTest
extends ShareTest {
    public ParallelGuestSessionsTest(String name) {
        super(name);
    }

    public void testParallelInvitedGuestSessions() throws Exception {
        int module = ParallelGuestSessionsTest.randomModule();
        this.testParallelGuestSessions(ParallelGuestSessionsTest.randomFolderAPI(), module, this.getDefaultFolder(module), ParallelGuestSessionsTest.randomGuestPermission(RecipientType.GUEST, module));
    }

    public void testParallelAnonymousGuestSessions() throws Exception {
        int module = ParallelGuestSessionsTest.randomModule();
        this.testParallelGuestSessions(ParallelGuestSessionsTest.randomFolderAPI(), module, this.getDefaultFolder(module), ParallelGuestSessionsTest.randomGuestPermission(RecipientType.ANONYMOUS, module));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParallelGuestSessions(EnumAPI api, int module, int parent, OCLGuestPermission guestPermission) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, module, parent);
        folder.addPermission((OCLPermission)guestPermission);
        folder = this.updateFolder(api, folder);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        ParallelGuestSessionsTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        ParallelGuestSessionsTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        ParallelGuestSessionsTest.checkGuestPermission(guestPermission, guest);
        String shareURL = this.discoverShareURL(guest);
        AJAXSession sharedSession = this.getSession();
        String oldSessionID = sharedSession.getId();
        try {
            sharedSession.setId(null);
            GuestClient guestClient = new GuestClient(sharedSession, shareURL, guestPermission.getRecipient(), true, false);
            guestClient.checkShareModuleAvailable();
            guestClient.checkShareAccessible(guestPermission);
        }
        finally {
            sharedSession.setId(oldSessionID);
        }
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        ParallelGuestSessionsTest.checkGuestPermission(guestPermission, guest);
    }
}

