/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.NotifyFileRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsResponse;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.RecipientType;

public class NotifyFileSharesTest
extends ShareTest {
    public NotifyFileSharesTest(String name) {
        super(name);
    }

    public void testNotifyGuest() throws Exception {
        this.testNotifyGuest(this.getDefaultFolder(8));
        this.testNotifyGuest(this.insertPublicFolder(EnumAPI.OX_NEW, 8).getObjectID());
    }

    public void testNotifyGroup() throws Exception {
        this.testNotifyGroup(this.getDefaultFolder(8));
        this.testNotifyGroup(this.insertPublicFolder(EnumAPI.OX_NEW, 8).getObjectID());
    }

    public void testNotifyUser() throws Exception {
        this.testNotifyUser(this.getDefaultFolder(8));
        this.testNotifyUser(this.insertPublicFolder(EnumAPI.OX_NEW, 8).getObjectID());
    }

    private void testNotifyGuest(int parent) throws Exception {
        FileStorageGuestObjectPermission permission = NotifyFileSharesTest.randomGuestObjectPermission(RecipientType.GUEST);
        String emailAddress = ((GuestRecipient)permission.getRecipient()).getEmailAddress();
        this.testNotify(parent, (FileStorageObjectPermission)permission, emailAddress);
    }

    private void testNotifyGroup(int parent) throws Exception {
        DefaultFileStorageObjectPermission permission = new DefaultFileStorageObjectPermission(0, true, 1);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        String emailAddress = client2.getValues().getDefaultAddress();
        client2.logout();
        this.testNotify(parent, (FileStorageObjectPermission)permission, emailAddress);
    }

    private void testNotifyUser(int parent) throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        String emailAddress = client2.getValues().getDefaultAddress();
        client2.logout();
        DefaultFileStorageObjectPermission permission = new DefaultFileStorageObjectPermission(userId, false, 2);
        this.testNotify(parent, (FileStorageObjectPermission)permission, emailAddress);
    }

    private void testNotify(int parentFolder, FileStorageObjectPermission permission, String emailAddress) throws Exception {
        String filename = NotifyFileSharesTest.randomUID();
        File file = this.insertSharedFile(parentFolder, filename, permission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission objectPermission : file.getObjectPermissions()) {
            if (objectPermission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = objectPermission;
            break;
        }
        NotifyFileSharesTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        NotifyFileSharesTest.checkPermissions(permission, matchingPermission);
        this.client.execute(new GetMailsRequest());
        this.client.execute(new NotifyFileRequest(file.getId(), matchingPermission.getEntity()));
        GetMailsResponse.Message notificationMessage = this.discoverInvitationMessage(this.client, emailAddress);
        NotifyFileSharesTest.assertNotNull((Object)notificationMessage);
    }
}

