/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;

public class CreateWithGuestPermissionTest
extends ShareTest {
    public CreateWithGuestPermissionTest(String name) {
        super(name);
    }

    public void testCreateSharedFolderRandomly() throws Exception {
        int module = CreateWithGuestPermissionTest.randomModule();
        this.testCreateSharedFolder(CreateWithGuestPermissionTest.randomFolderAPI(), module, CreateWithGuestPermissionTest.randomGuestPermission(module));
    }

    public void notTestCreateSharedFolderExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (OCLGuestPermission guestPermission : TESTED_PERMISSIONS) {
                for (int module : TESTED_MODULES) {
                    this.testCreateSharedFolder(api, module, guestPermission);
                }
            }
        }
    }

    public void testCreateSharedFileRandomly() throws Exception {
        this.testCreateSharedFile(CreateWithGuestPermissionTest.randomFolderAPI(), CreateWithGuestPermissionTest.randomGuestObjectPermission());
    }

    public void noTestCreateSharedFileExtensively() throws Exception {
        for (FileStorageGuestObjectPermission guestPermission : TESTED_OBJECT_PERMISSIONS) {
            this.testCreateSharedFile(EnumAPI.OX_NEW, guestPermission);
        }
    }

    private void testCreateSharedFolder(EnumAPI api, int module, OCLGuestPermission guestPermission) throws Exception {
        this.testCreateSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
    }

    private void testCreateSharedFolder(EnumAPI api, int module, int parent, OCLGuestPermission guestPermission) throws Exception {
        FolderObject folder = this.insertSharedFolder(api, module, parent, guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        CreateWithGuestPermissionTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        CreateWithGuestPermissionTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        CreateWithGuestPermissionTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(this.discoverShareURL(guest), guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }

    private void testCreateSharedFile(EnumAPI api, FileStorageGuestObjectPermission guestPermission) throws Exception {
        this.testCreateSharedFile(api, this.getDefaultFolder(8), guestPermission);
    }

    private void testCreateSharedFile(EnumAPI api, int parent, FileStorageGuestObjectPermission guestPermission) throws Exception {
        byte[] contents = new byte[64 + random.nextInt(256)];
        random.nextBytes(contents);
        String filename = CreateWithGuestPermissionTest.randomUID();
        FolderObject folder = this.insertPrivateFolder(api, 8, parent);
        File file = this.insertSharedFile(folder.getObjectID(), filename, (FileStorageObjectPermission)guestPermission, contents);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        CreateWithGuestPermissionTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        CreateWithGuestPermissionTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        CreateWithGuestPermissionTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestClient guestClient = this.resolveShare(this.discoverShareURL(guest), guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission, contents);
    }
}

