/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.ajax.share.actions.StartSMTPRequest;
import com.openexchange.ajax.share.actions.StopSMTPRequest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.notification.ShareNotificationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggregateSharesTest
extends ShareTest {
    private Map<AJAXClient, List<Integer>> clientsAndFolders;
    private AJAXClient client2;

    public AggregateSharesTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.client2.execute(new StartSMTPRequest());
        this.clientsAndFolders = new HashMap<AJAXClient, List<Integer>>();
        this.clientsAndFolders.put(this.client, new ArrayList());
        this.clientsAndFolders.put(this.client2, new ArrayList());
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.clientsAndFolders) {
            for (Map.Entry<AJAXClient, List<Integer>> entry : this.clientsAndFolders.entrySet()) {
                AggregateSharesTest.deleteFoldersSilently(entry.getKey(), (Collection<Integer>)entry.getValue());
                if (entry.getKey().equals(this.client)) continue;
                entry.getKey().execute(new StopSMTPRequest());
                entry.getKey().logout();
            }
        }
        super.tearDown();
    }

    private AJAXClient randomClient() {
        AJAXClient[] ajaxClients = this.clientsAndFolders.keySet().toArray(new AJAXClient[this.clientsAndFolders.size()]);
        return ajaxClients[random.nextInt(ajaxClients.length)];
    }

    public void testAggregateSharesRandomly() throws Exception {
        this.testAggregateShares(AggregateSharesTest.randomFolderAPI(), this.randomClient(), AggregateSharesTest.randomModule(), this.randomClient(), AggregateSharesTest.randomModule());
    }

    public void noTestAggregateSharesExtensively() throws Exception {
        AJAXClient[] ajaxClients = this.clientsAndFolders.keySet().toArray(new AJAXClient[this.clientsAndFolders.size()]);
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (AJAXClient client1 : ajaxClients) {
                for (int module1 : TESTED_MODULES) {
                    for (AJAXClient client2 : ajaxClients) {
                        for (int module2 : TESTED_MODULES) {
                            this.testAggregateShares(api, client1, module1, client2, module2);
                        }
                    }
                }
            }
        }
    }

    public void testRemoveAggregateSharesRandomly() throws Exception {
        this.testRemoveAggregateShares(AggregateSharesTest.randomFolderAPI(), this.randomClient(), AggregateSharesTest.randomModule(), this.randomClient(), AggregateSharesTest.randomModule());
    }

    public void noTestRemoveAggregateSharesExtensively() throws Exception {
        AJAXClient[] ajaxClients = this.clientsAndFolders.keySet().toArray(new AJAXClient[this.clientsAndFolders.size()]);
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (AJAXClient client1 : ajaxClients) {
                for (int module1 : TESTED_MODULES) {
                    for (AJAXClient client2 : ajaxClients) {
                        for (int module2 : TESTED_MODULES) {
                            this.testRemoveAggregateShares(api, client1, module1, client2, module2);
                        }
                    }
                }
            }
        }
    }

    private void testAggregateShares(EnumAPI api, AJAXClient client1, int module1, AJAXClient client2, int module2) throws Exception {
        String name = AggregateSharesTest.randomUID();
        OCLGuestPermission guestPermission = AggregateSharesTest.createNamedGuestPermission(name + "@example.com", name, "secret");
        FolderObject folderA = Create.createPrivateFolder(AggregateSharesTest.randomUID(), module1, client1.getValues().getUserId(), guestPermission);
        folderA.setParentFolderID(AggregateSharesTest.getDefaultFolder(client1, module1));
        InsertRequest insertRequest1 = new InsertRequest((API)api, folderA);
        insertRequest1.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse insertResponse1 = client1.execute(insertRequest1);
        insertResponse1.fillObject((DataObject)folderA);
        this.clientsAndFolders.get(client1).add(folderA.getObjectID());
        GetResponse getResponse1 = client1.execute(new GetRequest((API)api, folderA.getObjectID()));
        folderA = getResponse1.getFolder();
        folderA.setLastModified(getResponse1.getTimestamp());
        OCLPermission matchingPermissionA = null;
        for (OCLPermission permission : folderA.getPermissions()) {
            if (permission.getEntity() == client1.getValues().getUserId()) continue;
            matchingPermissionA = permission;
            break;
        }
        AggregateSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermissionA);
        AggregateSharesTest.checkPermissions(guestPermission, matchingPermissionA);
        ExtendedPermissionEntity guestA = AggregateSharesTest.discoverGuestEntity(client1, api, module1, folderA.getObjectID(), matchingPermissionA.getEntity());
        AggregateSharesTest.checkGuestPermission(guestPermission, guestA);
        String shareURLA = this.discoverShareURL(client1, guestA);
        FolderObject folderB = Create.createPrivateFolder(AggregateSharesTest.randomUID(), module2, client2.getValues().getUserId(), guestPermission);
        folderB.setParentFolderID(AggregateSharesTest.getDefaultFolder(client2, module2));
        InsertRequest insertRequest2 = new InsertRequest((API)api, folderB);
        insertRequest2.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse insertResponse2 = client2.execute(insertRequest2);
        insertResponse2.fillObject((DataObject)folderB);
        this.clientsAndFolders.get(client2).add(folderB.getObjectID());
        GetResponse getResponse = client2.execute(new GetRequest((API)api, folderB.getObjectID()));
        folderB = getResponse.getFolder();
        folderB.setLastModified(getResponse.getTimestamp());
        OCLPermission matchingPermissionB = null;
        for (OCLPermission permission : folderB.getPermissions()) {
            if (permission.getEntity() == client2.getValues().getUserId()) continue;
            matchingPermissionB = permission;
            break;
        }
        AggregateSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermissionB);
        AggregateSharesTest.checkPermissions(guestPermission, matchingPermissionB);
        ExtendedPermissionEntity guestB = AggregateSharesTest.discoverGuestEntity(client2, api, module2, folderB.getObjectID(), matchingPermissionB.getEntity());
        AggregateSharesTest.checkGuestPermission(guestPermission, guestB);
        String shareURLB = this.discoverShareURL(client2, guestB);
        AggregateSharesTest.assertEquals((String)"Permission entities differ", (int)matchingPermissionA.getEntity(), (int)matchingPermissionB.getEntity());
        GuestClient guestClientA = this.resolveShare(shareURLA, guestPermission.getRecipient());
        guestClientA.checkModuleAvailable(module1);
        guestClientA.checkModuleAvailable(module2);
        guestClientA.checkFolderAccessible(String.valueOf(folderA.getObjectID()), guestPermission);
        guestClientA.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
        GuestClient guestClientB = this.resolveShare(shareURLB, guestPermission.getRecipient());
        guestClientB.checkModuleAvailable(module1);
        guestClientB.checkModuleAvailable(module2);
        guestClientB.checkFolderAccessible(String.valueOf(folderA.getObjectID()), guestPermission);
        guestClientB.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
    }

    private void testRemoveAggregateShares(EnumAPI api, AJAXClient client1, int module1, AJAXClient client2, int module2) throws Exception {
        String name = AggregateSharesTest.randomUID();
        OCLGuestPermission guestPermission = AggregateSharesTest.createNamedGuestPermission(name + "@example.com", name, "secret");
        FolderObject folderA = Create.createPrivateFolder(AggregateSharesTest.randomUID(), module1, client1.getValues().getUserId(), guestPermission);
        folderA.setParentFolderID(AggregateSharesTest.getDefaultFolder(client1, module1));
        InsertRequest insertRequest1 = new InsertRequest((API)api, folderA);
        insertRequest1.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse insertResponse1 = client1.execute(insertRequest1);
        insertResponse1.fillObject((DataObject)folderA);
        this.clientsAndFolders.get(client1).add(folderA.getObjectID());
        GetResponse getResponse1 = client1.execute(new GetRequest((API)api, folderA.getObjectID()));
        folderA = getResponse1.getFolder();
        folderA.setLastModified(getResponse1.getTimestamp());
        OCLPermission matchingPermissionA = null;
        for (OCLPermission permission : folderA.getPermissions()) {
            if (permission.getEntity() == client1.getValues().getUserId()) continue;
            matchingPermissionA = permission;
            break;
        }
        AggregateSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermissionA);
        AggregateSharesTest.checkPermissions(guestPermission, matchingPermissionA);
        ExtendedPermissionEntity guestA = AggregateSharesTest.discoverGuestEntity(client1, api, module1, folderA.getObjectID(), matchingPermissionA.getEntity());
        AggregateSharesTest.checkGuestPermission(guestPermission, guestA);
        String shareURLA = this.discoverShareURL(client1, guestA);
        FolderObject folderB = Create.createPrivateFolder(AggregateSharesTest.randomUID(), module2, client2.getValues().getUserId(), guestPermission);
        folderB.setParentFolderID(AggregateSharesTest.getDefaultFolder(client2, module2));
        InsertRequest insertRequest2 = new InsertRequest((API)api, folderB);
        insertRequest2.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse insertResponse2 = client2.execute(insertRequest2);
        insertResponse2.fillObject((DataObject)folderB);
        this.clientsAndFolders.get(client2).add(folderB.getObjectID());
        GetResponse getResponse2 = client2.execute(new GetRequest((API)api, folderB.getObjectID()));
        folderB = getResponse2.getFolder();
        folderB.setLastModified(getResponse2.getTimestamp());
        OCLPermission matchingPermissionB = null;
        for (OCLPermission permission : folderB.getPermissions()) {
            if (permission.getEntity() == client2.getValues().getUserId()) continue;
            matchingPermissionB = permission;
            break;
        }
        AggregateSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermissionB);
        AggregateSharesTest.checkPermissions(guestPermission, matchingPermissionB);
        ExtendedPermissionEntity guestB = AggregateSharesTest.discoverGuestEntity(client2, api, module2, folderB.getObjectID(), matchingPermissionB.getEntity());
        AggregateSharesTest.checkGuestPermission(guestPermission, guestB);
        String shareURLB = this.discoverShareURL(client2, guestB);
        AggregateSharesTest.assertEquals((String)"Permission entities differ", (int)matchingPermissionA.getEntity(), (int)matchingPermissionB.getEntity());
        GuestClient guestClientA = this.resolveShare(shareURLA, guestPermission.getRecipient());
        guestClientA.checkModuleAvailable(module1);
        guestClientA.checkModuleAvailable(module2);
        guestClientA.checkFolderAccessible(String.valueOf(folderA.getObjectID()), guestPermission);
        guestClientA.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
        String folderATarget = guestClientA.getShareResolveResponse().getTarget();
        GuestClient guestClientB = this.resolveShare(shareURLB, guestPermission.getRecipient());
        guestClientB.checkModuleAvailable(module1);
        guestClientB.checkModuleAvailable(module2);
        guestClientB.checkFolderAccessible(String.valueOf(folderA.getObjectID()), guestPermission);
        guestClientB.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
        String folderBTarget = guestClientB.getShareResolveResponse().getTarget();
        folderA.getPermissions().remove(matchingPermissionA);
        insertResponse1 = client1.execute(new UpdateRequest((API)api, folderA));
        insertResponse1.fillObject((DataObject)folderA);
        this.clientsAndFolders.get(client1).add(folderA.getObjectID());
        getResponse1 = client1.execute(new GetRequest((API)api, folderA.getObjectID()));
        folderA = getResponse1.getFolder();
        folderA.setLastModified(getResponse1.getTimestamp());
        for (OCLPermission permission : folderA.getPermissions()) {
            AggregateSharesTest.assertTrue((String)"Guest permission still present", (permission.getEntity() != matchingPermissionA.getEntity() ? 1 : 0) != 0);
        }
        guestClientA.checkSessionAlive(false);
        guestClientA.checkModuleAvailable(module2);
        guestClientA.checkFolderNotAccessible(String.valueOf(folderA.getObjectID()));
        guestClientA.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
        guestClientB.checkSessionAlive(false);
        guestClientB.checkModuleAvailable(module2);
        guestClientB.checkFolderNotAccessible(String.valueOf(folderA.getObjectID()));
        guestClientB.checkFolderAccessible(String.valueOf(folderB.getObjectID()), guestPermission);
        ResolveShareResponse shareResolveResponse = new GuestClient(shareURLA, guestPermission.getRecipient(), false).getShareResolveResponse();
        AggregateSharesTest.assertEquals((String)"Login type wrong", (String)"guest_password", (String)shareResolveResponse.getLoginType());
        AggregateSharesTest.assertEquals((String)"Status wrong", (String)"not_found_continue", (String)shareResolveResponse.getStatus());
        AggregateSharesTest.assertEquals((String)"Target wrong", (String)folderBTarget, (String)shareResolveResponse.getTarget());
        shareResolveResponse = new GuestClient(shareURLB, guestPermission.getRecipient()).getShareResolveResponse();
        AggregateSharesTest.assertEquals((String)"Status code wrong", (int)302, (int)shareResolveResponse.getStatusCode());
    }
}

