/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.DeleteLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.share.ShareTarget;

public class Bug41287Test
extends ShareTest {
    private FolderObject parent;
    private FolderObject subfolder;
    private ShareTarget target;

    public Bug41287Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.parent = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
        this.subfolder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.parent.getObjectID());
        this.remember(this.subfolder);
        this.remember(this.parent);
        this.target = new ShareTarget(8, String.valueOf(this.subfolder.getObjectID()));
        GetLinkRequest req = new GetLinkRequest(this.target);
        this.client.execute(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            DeleteLinkRequest req = new DeleteLinkRequest(this.target, System.currentTimeMillis());
            this.client.execute(req);
        }
        finally {
            super.tearDown();
        }
    }

    public void testBug41287() throws Exception {
        ShareTarget t = new ShareTarget(8, String.valueOf(this.parent.getObjectID()));
        GetLinkRequest req = new GetLinkRequest(t);
        GetLinkResponse resp = this.client.execute(req);
        Bug41287Test.assertFalse((boolean)resp.hasError());
        String url = resp.getShareLink().getShareURL();
        GuestClient guestClient = this.resolveShare(url);
        OCLGuestPermission perm = Bug41287Test.createAnonymousGuestPermission();
        perm.setEntity(guestClient.getValues().getUserId());
        guestClient.checkFolderAccessible(String.valueOf(this.parent.getObjectID()), perm);
    }
}

