/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.find.Module;
import com.openexchange.find.drive.DriveFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.share.ShareTarget;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class Bug40651Test
extends ShareTest {
    public Bug40651Test(String name) {
        super(name);
    }

    public void testShareFileLinkAndSearchForItAsGuest() throws Exception {
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
        File file = this.insertFile(folder.getObjectID(), "Tests.zip");
        ShareTarget target = new ShareTarget(8, Integer.toString(folder.getObjectID()), file.getId());
        GetLinkRequest getLinkRequest = new GetLinkRequest(target, this.client.getValues().getTimeZone());
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getShareLink().getShareURL();
        GuestClient guestClient = this.resolveShare(url);
        List<Facet> facets = AbstractFindTest.autocomplete(guestClient, Module.DRIVE, "tests");
        ArrayList<ActiveFacet> activeFacets = new ArrayList<ActiveFacet>(2);
        activeFacets.add(AbstractFindTest.createActiveFolderFacet("10"));
        activeFacets.add(AbstractFindTest.createActiveFacet((SimpleFacet)AbstractFindTest.findByType((FacetType)DriveFacetType.FILE_NAME, facets)));
        List<PropDocument> searchResults = AbstractFindTest.query(guestClient, Module.DRIVE, activeFacets);
        FileID expectedId = new FileID(file.getId());
        expectedId.setFolderId("10");
        PropDocument expectedDoc = AbstractFindTest.findByProperty(searchResults, "id", expectedId.toUniqueID());
        Assert.assertNotNull((String)("Found no document with ID " + expectedId.toUniqueID()), (Object)expectedDoc);
    }

    public void testShareFolderLinkAndSearchForContainedItemAsGuest() throws Exception {
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
        File file = this.insertFile(folder.getObjectID(), "Tests.zip");
        ShareTarget target = new ShareTarget(8, Integer.toString(folder.getObjectID()));
        GetLinkRequest getLinkRequest = new GetLinkRequest(target, this.client.getValues().getTimeZone());
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getShareLink().getShareURL();
        GuestClient guestClient = this.resolveShare(url);
        List<Facet> facets = AbstractFindTest.autocomplete(guestClient, Module.DRIVE, "tests");
        ArrayList<ActiveFacet> activeFacets = new ArrayList<ActiveFacet>(2);
        activeFacets.add(AbstractFindTest.createActiveFolderFacet("10"));
        activeFacets.add(AbstractFindTest.createActiveFacet((SimpleFacet)AbstractFindTest.findByType((FacetType)DriveFacetType.FILE_NAME, facets)));
        List<PropDocument> searchResults = AbstractFindTest.query(guestClient, Module.DRIVE, activeFacets);
        PropDocument expectedDoc = AbstractFindTest.findByProperty(searchResults, "id", file.getId());
        Assert.assertNotNull((String)("Found no document with ID " + file.getId()), (Object)expectedDoc);
    }
}

