/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.share.actions.ShareWriter;
import com.openexchange.ajax.share.actions.UpdateLinkResponse;
import com.openexchange.java.util.TimeZones;
import com.openexchange.share.ShareTarget;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateLinkRequest
implements AJAXRequest<UpdateLinkResponse> {
    private final ShareTarget target;
    private final long timestamp;
    private final TimeZone timeZone;
    private final boolean failOnError = true;
    private String password = null;
    private boolean containsPassword;
    private Date expiryDate;
    private boolean containsExpiryDate;

    public UpdateLinkRequest(ShareTarget target, long timestamp) {
        this.target = target;
        this.timestamp = timestamp;
        this.timeZone = TimeZones.UTC;
    }

    public UpdateLinkRequest(ShareTarget target, TimeZone timeZone, long timestamp) {
        this.target = target;
        this.timestamp = timestamp;
        this.timeZone = timeZone;
    }

    public void setPassword(String password) {
        this.password = password;
        this.containsPassword = true;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
        this.containsExpiryDate = true;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public String getServletPath() {
        return "/ajax/share/management";
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new Params("action", "updateLink", "timestamp", Long.toString(this.timestamp)).toArray();
    }

    @Override
    public AbstractAJAXParser<UpdateLinkResponse> getParser() {
        return new Parser(true);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject json = ShareWriter.writeTarget(this.target);
        if (this.containsExpiryDate) {
            if (null == this.expiryDate) {
                json.put("expiry_date", JSONObject.NULL);
            } else {
                long date = this.expiryDate.getTime();
                if (null != this.timeZone) {
                    date += (long)this.timeZone.getOffset(date);
                }
                json.put("expiry_date", date);
            }
        }
        if (this.containsPassword) {
            json.put("password", null == this.password ? JSONObject.NULL : this.password);
        }
        return json;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    private static final class Parser
    extends AbstractAJAXParser<UpdateLinkResponse> {
        protected Parser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected UpdateLinkResponse createResponse(Response response) throws JSONException {
            return new UpdateLinkResponse(response);
        }
    }
}

