/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.json.FileMetadataFieldParser;
import com.openexchange.file.storage.meta.FileFieldSet;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileShare
extends DefaultFile {
    private List<ExtendedPermissionEntity> extendedFolderPermissions;

    public static FileShare parse(JSONArray jsonFile, int[] columns, TimeZone timeZone) throws JSONException, OXException {
        FileShare fileShare = new FileShare();
        FileFieldSet fileFieldSet = new FileFieldSet();
        block3: for (int i = 0; i < columns.length; ++i) {
            switch (columns[i]) {
                case 7010: {
                    fileShare.extendedFolderPermissions = ExtendedPermissionEntity.parse(jsonFile.optJSONArray(i), timeZone);
                    continue block3;
                }
                default: {
                    File.Field field = File.Field.get((int)columns[i]);
                    Object orig = jsonFile.get(i);
                    Object converted = FileMetadataFieldParser.convert((File.Field)field, (Object)orig);
                    field.doSwitch((FileFieldSwitcher)fileFieldSet, new Object[]{fileShare, converted});
                }
            }
        }
        return fileShare;
    }

    public static FileShare parse(JSONObject jsonObject, TimeZone timeZone) throws OXException, JSONException {
        FileShare fileShare = new FileShare();
        FileFieldSet fileFieldSet = new FileFieldSet();
        for (String key : jsonObject.keySet()) {
            if ("com.openexchange.share.extendedObjectPermissions".equals(key)) {
                fileShare.extendedFolderPermissions = ExtendedPermissionEntity.parse(jsonObject.optJSONArray(key), timeZone);
                continue;
            }
            File.Field field = File.Field.get((String)key);
            if (null == field) continue;
            Object orig = jsonObject.get(key);
            Object converted = FileMetadataFieldParser.convert((File.Field)field, (Object)orig);
            field.doSwitch((FileFieldSwitcher)fileFieldSet, new Object[]{fileShare, converted});
        }
        return fileShare;
    }

    private FileShare() throws JSONException {
    }

    public List<ExtendedPermissionEntity> getExtendedPermissions() {
        return this.extendedFolderPermissions;
    }
}

