/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.share.actions.DeleteLinkResponse;
import com.openexchange.ajax.share.actions.ShareWriter;
import com.openexchange.share.ShareTarget;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteLinkRequest
implements AJAXRequest<DeleteLinkResponse> {
    private final ShareTarget target;
    private final long timestamp;
    private final boolean failOnError = true;

    public DeleteLinkRequest(ShareTarget target, long timestamp) {
        this.timestamp = timestamp;
        this.target = target;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new Params("action", "deleteLink", "timestamp", Long.toString(this.timestamp)).toArray();
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject json = ShareWriter.writeTarget(this.target);
        return json;
    }

    @Override
    public String getServletPath() {
        return "/ajax/share/management";
    }

    @Override
    public AbstractAJAXParser<DeleteLinkResponse> getParser() {
        return new AbstractAJAXParser<DeleteLinkResponse>(true){

            @Override
            protected DeleteLinkResponse createResponse(Response response) throws JSONException {
                return new DeleteLinkResponse(response);
            }
        };
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }
}

