/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.session.actions.LoginResponse;
import java.io.IOException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElementIterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginResponseParser
extends AbstractAJAXParser<LoginResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(LoginResponseParser.class);
    private String jvmRoute;

    LoginResponseParser(boolean failOnError) {
        super(failOnError);
    }

    @Override
    public String checkResponse(HttpResponse resp, HttpRequest request) throws ParseException, IOException {
        String body = super.checkResponse(resp, request);
        try {
            super.getResponse(body);
        }
        catch (JSONException e) {
            LOG.error("Invalid login body: \"" + body + "\"");
            LoginResponseParser.fail((String)e.getMessage());
        }
        if (this.isFailOnError()) {
            boolean oxCookieFound = false;
            boolean jsessionIdCookieFound = false;
            BasicHeaderElementIterator iter = new BasicHeaderElementIterator(resp.headerIterator("Set-Cookie"));
            while (iter.hasNext()) {
                HeaderElement element = iter.nextElement();
                if (element.getName().startsWith(LoginServlet.SECRET_PREFIX)) {
                    oxCookieFound = true;
                    continue;
                }
                if (!"JSESSIONID".equals(element.getName())) continue;
                jsessionIdCookieFound = true;
                String jsessionId = element.getValue();
                int dotPos = jsessionId.lastIndexOf(46);
                LoginResponseParser.assertTrue((String)"jvmRoute is missing.", (dotPos > 0 ? 1 : 0) != 0);
                this.jvmRoute = jsessionId.substring(dotPos + 1);
            }
            LoginResponseParser.assertTrue((String)"Secret cookie is missing.", (boolean)oxCookieFound);
            LoginResponseParser.assertTrue((String)"JSESSIONID cookie is missing.", (boolean)jsessionIdCookieFound);
        }
        return body;
    }

    @Override
    public LoginResponse parse(String body) throws JSONException {
        JSONObject json = new JSONObject(body);
        Response response = this.getResponse(body);
        response.setData((Object)json);
        return this.createResponse(response);
    }

    @Override
    protected LoginResponse createResponse(Response response) throws JSONException {
        LoginResponse retval = new LoginResponse(response);
        JSONObject json = (JSONObject)response.getData();
        if (response.hasError()) {
            response.setData(null);
        } else {
            retval.setJvmRoute(this.jvmRoute);
            retval.setSessionId(json.getString("session"));
            retval.setRandom(json.optString("random"));
            if (json.has("password")) {
                retval.setPassword(json.getString("password"));
            }
        }
        if (this.isFailOnError()) {
            LoginResponseParser.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
            LoginResponseParser.assertTrue((String)"Session ID is missing.", (boolean)json.has("session"));
            LoginResponseParser.assertFalse((String)"Random should be missing.", (boolean)json.has("random"));
        }
        return retval;
    }
}

