/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.quota;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.quota.GetQuotaRequest;
import com.openexchange.ajax.quota.GetQuotaResponse;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetQuotaTest
extends AbstractAJAXSession {
    public GetQuotaTest(String name) {
        super(name);
    }

    public void testGetQuota() throws Exception {
        GetQuotaRequest request = new GetQuotaRequest(null, null);
        GetQuotaResponse response = this.client.execute(request);
        JSONObject jsonModules = (JSONObject)response.getData();
        GetQuotaTest.assertNotNull((String)"No response data", (Object)jsonModules);
        Set modules = jsonModules.keySet();
        if (null != modules && 0 < modules.size()) {
            Random random = new Random();
            String randomModule = modules.toArray(new String[modules.size()])[random.nextInt(modules.size())];
            JSONObject jsonModule = jsonModules.getJSONObject(randomModule);
            GetQuotaTest.assertTrue((String)"No display_name found", (boolean)jsonModule.hasAndNotNull("display_name"));
            GetQuotaTest.assertTrue((String)"No accounts array found", (boolean)jsonModule.hasAndNotNull("accounts"));
            request = new GetQuotaRequest(randomModule, null);
            response = this.client.execute(request);
            JSONArray jsonAccounts = (JSONArray)response.getData();
            GetQuotaTest.assertNotNull((String)"No response data", (Object)jsonAccounts);
            if (0 < jsonAccounts.length()) {
                JSONObject randomAccount = jsonAccounts.getJSONObject(random.nextInt(jsonAccounts.length()));
                GetQuotaTest.assertTrue((String)"No account_id found", (boolean)randomAccount.hasAndNotNull("account_id"));
                GetQuotaTest.assertTrue((String)"No account_name found", (boolean)randomAccount.hasAndNotNull("account_name"));
                GetQuotaTest.assertTrue((String)"No quota or countquota found", (randomAccount.hasAndNotNull("quota") || randomAccount.hasAndNotNull("countquota") ? 1 : 0) != 0);
                request = new GetQuotaRequest(randomModule, randomAccount.getString("account_id"));
                response = this.client.execute(request);
                JSONObject jsonAccount = (JSONObject)response.getData();
                GetQuotaTest.assertTrue((String)"No account_id found", (boolean)jsonAccount.hasAndNotNull("account_id"));
                GetQuotaTest.assertTrue((String)"No account_name found", (boolean)jsonAccount.hasAndNotNull("account_name"));
                GetQuotaTest.assertTrue((String)"No quota or countquota found", (jsonAccount.hasAndNotNull("quota") || randomAccount.hasAndNotNull("countquota") ? 1 : 0) != 0);
            }
        }
    }
}

