/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.onboarding.tests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.onboarding.actions.ExecuteRequest;
import com.openexchange.ajax.onboarding.actions.OnboardingTestResponse;
import com.openexchange.ajax.onboarding.actions.StartSMTPRequest;
import com.openexchange.ajax.onboarding.actions.StopSMTPRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsResponse;
import java.util.List;
import org.json.JSONObject;

public class MailSyncProfileTest
extends AbstractAJAXSession {
    public MailSyncProfileTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        StartSMTPRequest req = new StartSMTPRequest(true);
        req.setUpdateNoReplyForContext(this.client.getValues().getContextId());
        this.client.execute(req);
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.client) {
            this.client.execute(new StopSMTPRequest());
        }
        super.tearDown();
    }

    public void testIMAPSyncProfileViaEmail() throws Exception {
        JSONObject body = new JSONObject();
        body.put("email", (Object)this.client.getValues().getDefaultAddress());
        ExecuteRequest req = new ExecuteRequest("apple.mac/mailsync", "email", body, false);
        this.client.execute(req);
        GetMailsRequest mailReq = new GetMailsRequest();
        GetMailsResponse mailResp = this.client.execute(mailReq);
        List<GetMailsResponse.Message> messages = mailResp.getMessages();
        MailSyncProfileTest.assertNotNull(messages);
        MailSyncProfileTest.assertEquals((int)1, (int)messages.size());
    }

    public void testIMAPSyncProfileViaDisplay() throws Exception {
        ExecuteRequest req = new ExecuteRequest("apple.mac/mailmanual", "display", null, false);
        OnboardingTestResponse resp = this.client.execute(req);
        MailSyncProfileTest.assertFalse((boolean)resp.hasError());
        JSONObject json = (JSONObject)resp.getData();
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("imapLogin"));
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("imapServer"));
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("imapPort"));
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("imapSecure"));
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("smtpLogin"));
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("smtpServer"));
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("smtpPort"));
        MailSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("smtpSecure"));
    }
}

