/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.onboarding.tests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.onboarding.actions.ExecuteRequest;
import com.openexchange.ajax.onboarding.actions.OnboardingTestResponse;
import com.openexchange.ajax.onboarding.actions.StartSMTPRequest;
import com.openexchange.ajax.onboarding.actions.StopSMTPRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsResponse;
import java.util.List;
import org.json.JSONObject;

public class EASSyncProfileTest
extends AbstractAJAXSession {
    public EASSyncProfileTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        StartSMTPRequest req = new StartSMTPRequest(true);
        req.setUpdateNoReplyForContext(this.client.getValues().getContextId());
        this.client.execute(req);
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.client) {
            this.client.execute(new StopSMTPRequest());
        }
        super.tearDown();
    }

    public void testEASSyncProfileViaEmail() throws Exception {
        JSONObject body = new JSONObject();
        body.put("email", (Object)this.client.getValues().getDefaultAddress());
        ExecuteRequest req = new ExecuteRequest("apple.iphone/eassync", "email", body, false);
        OnboardingTestResponse resp = this.client.execute(req);
        EASSyncProfileTest.assertFalse((boolean)resp.hasError());
        GetMailsRequest mailReq = new GetMailsRequest();
        GetMailsResponse mailResp = this.client.execute(mailReq);
        List<GetMailsResponse.Message> messages = mailResp.getMessages();
        EASSyncProfileTest.assertNotNull(messages);
        EASSyncProfileTest.assertEquals((int)1, (int)messages.size());
    }

    public void testEASSyncProfileViaDisplay() throws Exception {
        ExecuteRequest req = new ExecuteRequest("apple.iphone/easmanual", "display", null, false);
        OnboardingTestResponse resp = this.client.execute(req);
        EASSyncProfileTest.assertFalse((boolean)resp.hasError());
        JSONObject json = (JSONObject)resp.getData();
        EASSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("eas_url"));
        EASSyncProfileTest.assertTrue((boolean)json.hasAndNotNull("eas_login"));
    }
}

