/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.ajax.oauth.provider.EndpointTest;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TokenEndpointTest
extends EndpointTest {
    @Test
    public void testPOSTWithWrongProtocol() throws Exception {
        LinkedList<BasicNameValuePair> tokenParams = new LinkedList<BasicNameValuePair>();
        tokenParams.add(new BasicNameValuePair("param", "value"));
        HttpPost redeemToken = new HttpPost(new URIBuilder().setScheme("http").setHost(hostname).setPath("/ajax/oauth/provider/accessToken").build());
        redeemToken.setEntity((HttpEntity)new UrlEncodedFormEntity(tokenParams));
        HttpResponse tokenResponse = this.executeAndConsume((HttpRequestBase)redeemToken);
        this.expectSecureRedirect((HttpUriRequest)redeemToken, tokenResponse);
    }

    @Test
    public void testRedeemAuthCodeWithInvalidClientId() throws Exception {
        this.testRedeemAuthCodeWithMissingAndInvalidParam("client_id");
    }

    @Test
    public void testRedeemAuthCodeWithInvalidClientSecret() throws Exception {
        this.testRedeemAuthCodeWithMissingAndInvalidParam("client_secret");
    }

    @Test
    public void testRedeemAuthCodeWithInvalidGrantType() throws Exception {
        this.testRedeemAuthCodeWithMissingAndInvalidParam("grant_type");
    }

    @Test
    public void testRedeemAuthCodeWithInvalidCode() throws Exception {
        this.testRedeemAuthCodeWithMissingAndInvalidParam("code");
    }

    @Test
    public void testRedeemAuthCodeWithInvalidRedirectURI() throws Exception {
        this.testRedeemAuthCodeWithMissingAndInvalidParam("redirect_uri");
    }

    @Test
    public void testRedeemRefreshTokenWithInvalidClientId() throws Exception {
        this.testRedeemRefreshTokenWithMissingAndInvalidParam("client_id");
    }

    @Test
    public void testRedeemRefreshTokenWithInvalidClientSecret() throws Exception {
        this.testRedeemRefreshTokenWithMissingAndInvalidParam("client_secret");
    }

    @Test
    public void testRedeemRefreshTokenWithInvalidGrantType() throws Exception {
        this.testRedeemRefreshTokenWithMissingAndInvalidParam("grant_type");
    }

    @Test
    public void testRedeemRefreshTokenWithInvalidRefreshToken() throws Exception {
        this.testRedeemRefreshTokenWithMissingAndInvalidParam("refresh_token");
    }

    private void testRedeemAuthCodeWithMissingAndInvalidParam(String param) throws Exception {
        LinkedList<BasicNameValuePair> necessaryParams = new LinkedList<BasicNameValuePair>();
        necessaryParams.add(new BasicNameValuePair("client_id", this.getClientId()));
        necessaryParams.add(new BasicNameValuePair("client_secret", this.getClientSecret()));
        necessaryParams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        necessaryParams.add(new BasicNameValuePair("code", "invalid"));
        necessaryParams.add(new BasicNameValuePair("redirect_uri", this.getRedirectURI()));
        LinkedList<BasicNameValuePair> requestParams = new LinkedList<BasicNameValuePair>(necessaryParams);
        Iterator it = requestParams.iterator();
        while (it.hasNext()) {
            NameValuePair pair = (NameValuePair)it.next();
            if (!pair.getName().equals(param)) continue;
            it.remove();
            break;
        }
        HttpPost redeemToken = new HttpPost(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/accessToken").build());
        redeemToken.setEntity((HttpEntity)new UrlEncodedFormEntity(requestParams));
        HttpResponse tokenResponse = this.client.execute((HttpUriRequest)redeemToken);
        String responseBody = EntityUtils.toString((HttpEntity)tokenResponse.getEntity());
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)tokenResponse.containsHeader("Content-Type"));
        String contentType = tokenResponse.getFirstHeader("Content-Type").getValue();
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("application/json"));
        JSONObject jError = new JSONObject(responseBody);
        String errorCode = "invalid_request";
        if (errorCode != null) {
            Assert.assertEquals((Object)errorCode, (Object)jError.getString("error"));
        }
        requestParams = new LinkedList(necessaryParams);
        it = requestParams.iterator();
        while (it.hasNext()) {
            NameValuePair pair = (NameValuePair)it.next();
            if (!pair.getName().equals(param)) continue;
            it.remove();
            break;
        }
        requestParams.add(new BasicNameValuePair(param, "invalid"));
        redeemToken = new HttpPost(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/accessToken").build());
        tokenResponse = this.client.execute((HttpUriRequest)redeemToken);
        responseBody = EntityUtils.toString((HttpEntity)tokenResponse.getEntity());
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)tokenResponse.containsHeader("Content-Type"));
        contentType = tokenResponse.getFirstHeader("Content-Type").getValue();
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("application/json"));
        jError = new JSONObject(responseBody);
        if (errorCode != null) {
            Assert.assertEquals((Object)errorCode, (Object)jError.getString("error"));
        }
    }

    private void testRedeemRefreshTokenWithMissingAndInvalidParam(String param) throws Exception {
        LinkedList<BasicNameValuePair> necessaryParams = new LinkedList<BasicNameValuePair>();
        necessaryParams.add(new BasicNameValuePair("client_id", this.getClientId()));
        necessaryParams.add(new BasicNameValuePair("client_secret", this.getClientSecret()));
        necessaryParams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        necessaryParams.add(new BasicNameValuePair("refresh_token", "invalid"));
        LinkedList<BasicNameValuePair> requestParams = new LinkedList<BasicNameValuePair>(necessaryParams);
        Iterator it = requestParams.iterator();
        while (it.hasNext()) {
            NameValuePair pair = (NameValuePair)it.next();
            if (!pair.getName().equals(param)) continue;
            it.remove();
            break;
        }
        HttpPost redeemToken = new HttpPost(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/accessToken").build());
        redeemToken.setEntity((HttpEntity)new UrlEncodedFormEntity(requestParams));
        HttpResponse tokenResponse = this.client.execute((HttpUriRequest)redeemToken);
        String responseBody = EntityUtils.toString((HttpEntity)tokenResponse.getEntity());
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)tokenResponse.containsHeader("Content-Type"));
        String contentType = tokenResponse.getFirstHeader("Content-Type").getValue();
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("application/json"));
        JSONObject jError = new JSONObject(responseBody);
        String errorCode = "invalid_request";
        if (errorCode != null) {
            Assert.assertEquals((Object)errorCode, (Object)jError.getString("error"));
        }
        requestParams = new LinkedList(necessaryParams);
        it = requestParams.iterator();
        while (it.hasNext()) {
            NameValuePair pair = (NameValuePair)it.next();
            if (!pair.getName().equals(param)) continue;
            it.remove();
            break;
        }
        requestParams.add(new BasicNameValuePair(param, "invalid"));
        redeemToken = new HttpPost(new URIBuilder().setScheme("https").setHost(hostname).setPath("/ajax/oauth/provider/accessToken").build());
        tokenResponse = this.client.execute((HttpUriRequest)redeemToken);
        responseBody = EntityUtils.toString((HttpEntity)tokenResponse.getEntity());
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)tokenResponse.containsHeader("Content-Type"));
        contentType = tokenResponse.getFirstHeader("Content-Type").getValue();
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("application/json"));
        jError = new JSONObject(responseBody);
        if (errorCode != null) {
            Assert.assertEquals((Object)errorCode, (Object)jError.getString("error"));
        }
    }
}

