/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.manifests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.manifests.actions.ConfigRequest;
import com.openexchange.ajax.manifests.actions.ConfigResponse;
import java.util.Comparator;
import org.json.JSONArray;
import org.json.JSONException;

public class Bug30835Test
extends AbstractAJAXSession {
    private JSONComparator comp;

    public Bug30835Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.comp = new JSONComparator();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBug30835() throws Exception {
        ConfigRequest request = new ConfigRequest();
        ConfigResponse response = this.client.execute(request);
        JSONArray json = response.getConfig().getJSONArray("languages");
        Bug30835Test.assertFalse((String)"Response contains no languages", (boolean)json.isEmpty());
        Bug30835Test.assertTrue((String)"Response is not ordered", (boolean)this.isOrdered(json, this.comp));
    }

    private boolean isOrdered(JSONArray json, Comparator<JSONArray> comp) throws Exception {
        if (json.length() > 1) {
            for (int i = 1; i < json.length(); ++i) {
                JSONArray obj1;
                JSONArray obj0 = json.getJSONArray(i - 1);
                if (comp.compare(obj0, obj1 = json.getJSONArray(i)) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private class JSONComparator
    implements Comparator<JSONArray> {
        private JSONComparator() {
        }

        @Override
        public int compare(JSONArray o1, JSONArray o2) {
            if (o1.isEmpty() && o2.isEmpty()) {
                return 0;
            }
            if (o1.length() != o2.length()) {
                return o1.length() - o2.length();
            }
            try {
                String key1 = o1.getString(0);
                String key2 = o2.getString(0);
                int comp = key1.compareToIgnoreCase(key2);
                if (comp > 0) {
                    return comp;
                }
            }
            catch (JSONException e) {
                return 1;
            }
            return -1;
        }
    }
}

