/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.SearchParser;
import com.openexchange.ajax.mail.actions.SearchResponse;
import com.openexchange.groupware.search.Order;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchRequest
extends AbstractMailRequest<SearchResponse> {
    private final boolean failOnError;
    private final String folder;
    private final JSONObject searchObject;
    private final String[] patterns;
    private final int[] searchColumns;
    private final int sort;
    private final Order order;
    private final int[] columns;

    public SearchRequest(JSONObject searchObject, String folder, int[] columns, int sort, Order order, boolean failOnError) {
        this.searchObject = searchObject;
        this.failOnError = failOnError;
        this.columns = columns;
        this.searchColumns = null;
        this.patterns = null;
        this.folder = folder;
        this.sort = sort;
        this.order = order;
    }

    public SearchRequest(int[] searchColumns, String[] patterns, String folder, int[] columns, int sort, Order order, boolean failOnError) {
        this.searchColumns = searchColumns;
        this.patterns = patterns;
        this.columns = columns;
        this.failOnError = failOnError;
        this.searchObject = null;
        this.folder = folder;
        this.sort = sort;
        this.order = order;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "search"));
        params.add(new AJAXRequest.Parameter("folder", this.folder));
        params.add(new AJAXRequest.Parameter("columns", this.columns));
        params.add(new AJAXRequest.Parameter("sort", this.sort));
        params.add(new AJAXRequest.Parameter("order", OrderFields.write((Order)this.order)));
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public SearchParser getParser() {
        return new SearchParser(this.failOnError, this.columns);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        if (null != this.searchObject) {
            return this.searchObject;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < this.searchColumns.length; ++i) {
            JSONObject jo = new JSONObject();
            jo.put("pattern", (Object)this.patterns[i]);
            jo.put("field", this.searchColumns[i]);
        }
        return ja;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }
}

