/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.ReplyResponse;
import com.openexchange.java.Strings;
import java.util.LinkedList;
import org.json.JSONException;

public class ReplyRequest
extends AbstractMailRequest<ReplyResponse> {
    protected boolean failOnError;
    protected ViewOption view;
    protected String folderID;
    protected String mailID;
    protected String csid;

    public ReplyRequest() {
    }

    public ReplyRequest(String[] folderAndID) {
        this(folderAndID[0], folderAndID[1]);
    }

    public ReplyRequest(String folderID, String mailID) {
        this.folderID = folderID;
        this.mailID = mailID;
    }

    public ViewOption getView() {
        return this.view;
    }

    public void setView(ViewOption view) {
        this.view = view;
    }

    public String getFolderID() {
        return this.folderID;
    }

    public void setFolderID(String folderID) {
        this.folderID = folderID;
    }

    public String getCsid() {
        return this.csid;
    }

    public void setCsid(String csid) {
        this.csid = csid;
    }

    public String getMailID() {
        return this.mailID;
    }

    public void setMailID(String mailID) {
        this.mailID = mailID;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    public String getAction() {
        return "reply";
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", this.getAction()));
        list.add(new AJAXRequest.Parameter("folder", this.folderID));
        list.add(new AJAXRequest.Parameter("id", this.mailID));
        if (this.getView() != null) {
            list.add(new AJAXRequest.Parameter("view", this.getView().toString()));
        }
        if (!Strings.isEmpty((String)this.csid)) {
            list.add(new AJAXRequest.Parameter("csid", this.csid));
        }
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends ReplyResponse> getParser() {
        return new AbstractAJAXParser<ReplyResponse>(this.failOnError){

            @Override
            protected ReplyResponse createResponse(Response response) throws JSONException {
                return new ReplyResponse(response);
            }
        };
    }

    public static enum ViewOption {
        TEXT("text"),
        HTML("html");

        private String str;

        private ViewOption(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }

        public static ViewOption getBy(String str) {
            for (ViewOption option : ViewOption.values()) {
                if (!str.equals(option.toString())) continue;
                return option;
            }
            return null;
        }
    }
}

