/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug32351Test
extends AbstractMailTest {
    private UserValues values;
    String[][] fmid;

    public Bug32351Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.fmid) {
            this.client.execute(new DeleteRequest(this.fmid, true).ignoreError());
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug32355() throws OXException, IOException, JSONException {
        StringBuilder sb = new StringBuilder(8192);
        InputStreamReader streamReader = null;
        try {
            int read;
            streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "mail010.eml")), "UTF-8");
            char[] buf = new char[2048];
            while ((read = streamReader.read(buf, 0, 2048)) > 0) {
                sb.append(buf, 0, read);
            }
        }
        catch (Throwable throwable) {
            Streams.close(streamReader);
            throw throwable;
        }
        Streams.close((Closeable)streamReader);
        ByteArrayInputStream inputStream = Streams.newByteArrayInputStream((byte[])TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        sb = null;
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmid = importResp.getIds();
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            Bug32351Test.fail((String)"Error importing mail");
        }
        String mailID = json.getJSONObject(0).getString("id");
        String folderID = json.getJSONObject(0).getString("folder_id");
        final String[][] fmid = this.fmid;
        final AJAXClient client = this.client;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(2);
        final AtomicReference exc1 = new AtomicReference();
        Runnable deleteTask1 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    startLatch.await();
                    client.execute(new DeleteRequest(fmid, false));
                    System.out.println("Thread #1 performed deletion");
                }
                catch (Exception e) {
                    exc1.set(e);
                }
                finally {
                    endLatch.countDown();
                }
            }
        };
        new Thread(deleteTask1).start();
        final AtomicReference exc2 = new AtomicReference();
        Runnable deleteTask2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    startLatch.await();
                    client.execute(new DeleteRequest(fmid, false));
                    System.out.println("Thread #2 performed deletion");
                }
                catch (Exception e) {
                    exc2.set(e);
                }
                finally {
                    endLatch.countDown();
                }
            }
        };
        new Thread(deleteTask2).start();
        startLatch.countDown();
        try {
            endLatch.await();
            Bug32351Test.assertNull((String)"Unexpected error.", exc1.get());
            Bug32351Test.assertNull((String)"Unexpected error.", exc2.get());
        }
        catch (InterruptedException e) {
            Bug32351Test.fail((String)e.getMessage());
        }
    }
}

