/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.DeleteResponse;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AbortAttachmentDownloadTest
extends AbstractMailTest {
    private UserValues values;
    String[][] fmid;

    public AbortAttachmentDownloadTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.fmid) {
            this.client.execute(new DeleteRequest(this.fmid, true).ignoreError());
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAbortedAttachmentDownload() throws OXException, IOException, JSONException {
        int length;
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "bug31855.eml")), "UTF-8");
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        while ((length = streamReader.read(buf)) != -1) {
            sb.append(buf, 0, length);
        }
        streamReader.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TestMails.replaceAddresses(sb.toString(), this.client.getValues().getSendAddress()).getBytes(Charsets.UTF_8));
        ImportMailRequest importMailRequest = new ImportMailRequest(this.values.getInboxFolder(), MailFlag.SEEN.getValue(), inputStream);
        ImportMailResponse importResp = this.client.execute(importMailRequest);
        JSONArray json = (JSONArray)importResp.getData();
        this.fmid = importResp.getIds();
        int err = 0;
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 0) {
            AbortAttachmentDownloadTest.fail((String)"Error importing mail");
        }
        String mailID = json.getJSONObject(0).getString("id");
        String folderID = json.getJSONObject(0).getString("folder_id");
        GetRequest getRequest = new GetRequest(folderID, mailID);
        GetResponse response = Executor.execute(this.getSession(), getRequest);
        JSONArray array = response.getAttachments();
        AbortAttachmentDownloadTest.assertEquals((String)"Incorrect number of attachments", (int)3, (int)array.length());
        AbortAttachmentDownloadTest.assertEquals((String)"Incorrect content type of attachment 2", (String)"application/octet-stream", (String)array.getJSONObject(1).getString("content_type"));
        AbortAttachmentDownloadTest.assertEquals((String)"Incorrect content type of attachment 3", (String)"application/octet-stream", (String)array.getJSONObject(2).getString("content_type"));
        String protocol = AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL);
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        AJAXSession session = this.client.getSession();
        String sessionId = session.getId();
        InputStream in = null;
        try {
            String urlString = protocol + "://" + hostname + getRequest.getServletPath();
            urlString = urlString + "?action=attachment";
            urlString = urlString + "&session=" + sessionId;
            urlString = urlString + "&folder=" + this.urlEncode(folderID);
            urlString = urlString + "&id=" + this.urlEncode(mailID);
            urlString = urlString + "&attachment=2";
            URL myUrl = new URL(urlString);
            URLConnection urlConn = myUrl.openConnection();
            DefaultHttpClient httpClient = session.getHttpClient();
            List cookies = httpClient.getCookieStore().getCookies();
            StringBuilder cookieStringBuilder = new StringBuilder(512);
            boolean first = true;
            for (Cookie cookie : cookies) {
                if (first) {
                    first = false;
                } else {
                    cookieStringBuilder.append("; ");
                }
                cookieStringBuilder.append(cookie.getName()).append('=').append(cookie.getValue());
            }
            urlConn.setRequestProperty("Cookie", cookieStringBuilder.toString());
            urlConn.setRequestProperty("User-Agent", "HTTP API Testing Agent");
            in = urlConn.getInputStream();
            for (int i = 0; i < 4; ++i) {
                in.read();
            }
        }
        catch (Throwable throwable) {
            Streams.close(in);
            throw throwable;
        }
        Streams.close((Closeable)in);
        if (folderID != null && mailID != null) {
            DeleteResponse deleteResponse = this.client.execute(new DeleteRequest(folderID, mailID, true));
            AbortAttachmentDownloadTest.assertNull((String)"Error deleting mail. Artifacts remain", (Object)deleteResponse.getErrorMessage());
        }
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

