/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.thirdparty.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.infostore.thirdparty.actions.AbstractFileRequest;
import com.openexchange.ajax.infostore.thirdparty.actions.NewFileParser;
import com.openexchange.ajax.infostore.thirdparty.actions.NewFileResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class NewFileRequest
extends AbstractFileRequest<NewFileResponse> {
    private File file;
    private byte[] bytes;
    private String mimeType;
    private JSONObject metadata;

    private NewFileRequest(boolean failOnError) {
        super(failOnError);
    }

    public NewFileRequest(byte[] byteData, JSONObject metadata, String mimeType) {
        this(true);
        this.bytes = byteData;
        this.mimeType = mimeType;
        this.metadata = metadata;
    }

    public NewFileRequest(File file, JSONObject metadata, String mimeType) {
        this(true);
        this.file = file;
        this.mimeType = mimeType;
        this.metadata = metadata;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.POST;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> list = new ArrayList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.URLParameter("action", "new"));
        if (this.file != null) {
            list.add(new AJAXRequest.FileParameter("file", this.file.getName(), new FileInputStream(this.file), this.mimeType));
        } else if (this.bytes != null) {
            list.add(new AJAXRequest.FileParameter("file", "random", new ByteArrayInputStream(this.bytes), this.mimeType));
        }
        list.add(new AJAXRequest.FieldParameter("json", this.metadata.toString()));
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends NewFileResponse> getParser() {
        return new NewFileParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return null;
    }

    @Override
    public Header[] getHeaders() {
        return new Header[]{new Header.SimpleHeader("Content-Type", "multipart/form-data")};
    }
}

