/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.thirdparty;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.infostore.thirdparty.ProviderIdMapper;
import com.openexchange.ajax.oauth.client.actions.OAuthService;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.FolderTestManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class AbstractInfostoreThirdpartyTest
extends AbstractAJAXSession {
    public FolderTestManager fMgr;

    public AbstractInfostoreThirdpartyTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.fMgr = new FolderTestManager(this.getClient());
    }

    @Override
    protected void tearDown() throws Exception {
        this.fMgr.cleanUp();
        super.tearDown();
    }

    protected List<ProviderIdMapper> getConnectedInfostoreId() throws Exception {
        FolderObject[] fObjs;
        int[] columns = new int[]{1, 20};
        ArrayList<ProviderIdMapper> providerIds = new ArrayList<ProviderIdMapper>();
        String folderId = null;
        for (FolderObject fObj : fObjs = this.fMgr.listFoldersOnServer(1, columns)) {
            if (fObj.getFullName() == null) continue;
            for (OAuthService authProvider : OAuthService.values()) {
                if (!fObj.getFullName().startsWith(authProvider.getFilestorageService())) continue;
                folderId = fObj.getFullName();
                ProviderIdMapper pidm = new ProviderIdMapper();
                pidm.setAuthProvider(authProvider);
                pidm.setInfostoreId(folderId);
                providerIds.add(pidm);
            }
        }
        if (providerIds == null || providerIds.isEmpty()) {
            throw new Exception("Could not find file storage for provider: ");
        }
        return providerIds;
    }

    protected byte[] randomBytes(int size) {
        byte[] randomBytes = new byte[size];
        Random rand = new Random();
        rand.nextBytes(randomBytes);
        return randomBytes;
    }

    protected JSONObject setFolderId(String value) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("folder_id", (Object)value);
        return json;
    }
}

