/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.infostore.actions.AllInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreResponse;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.Streams;
import com.openexchange.java.util.UUIDs;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.util.Date;
import java.util.UUID;
import org.json.JSONArray;

public class TrashTest
extends AbstractInfostoreTest {
    private final int[] COLUMNS = new int[]{1, 702, 20};
    private FolderObject testFolder;
    private int trashFolderID;

    public TrashTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testFolder = this.fMgr.generatePrivateFolder(UUID.randomUUID().toString(), 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId());
        this.testFolder = this.fMgr.insertFolderOnServer(this.testFolder);
        this.trashFolderID = this.client.getValues().getInfostoreTrashFolder();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHardDeleteFolder() throws Exception {
        FolderObject folder = this.createRandomFolder(this.testFolder.getObjectID());
        this.deleteFolder(folder, Boolean.TRUE);
        this.assertFolderNotExistsInFolder(this.testFolder.getObjectID(), folder.getObjectID());
        this.assertFolderNotExistsInFolder(this.trashFolderID, folder.getObjectID());
    }

    public void testSoftDeleteFolder() throws Exception {
        FolderObject folder = this.createRandomFolder(this.testFolder.getObjectID());
        this.deleteFolder(folder, Boolean.FALSE);
        this.assertFolderNotExistsInFolder(this.testFolder.getObjectID(), folder.getObjectID());
        this.assertFolderExistsInFolder(this.trashFolderID, folder.getObjectID());
    }

    public void testDefaultDeleteFolder() throws Exception {
        FolderObject folder = this.createRandomFolder(this.testFolder.getObjectID());
        this.deleteFolder(folder, null);
        this.assertFolderNotExistsInFolder(this.testFolder.getObjectID(), folder.getObjectID());
        this.assertFolderExistsInFolder(this.trashFolderID, folder.getObjectID());
    }

    public void testDeleteDeletedFolder() throws Exception {
        FolderObject folder = this.createRandomFolder(this.testFolder.getObjectID());
        this.deleteFolder(folder, null);
        this.assertFolderNotExistsInFolder(this.testFolder.getObjectID(), folder.getObjectID());
        this.assertFolderExistsInFolder(this.trashFolderID, folder.getObjectID());
        this.deleteFolder(folder, null);
        this.assertFolderNotExistsInFolder(this.testFolder.getObjectID(), folder.getObjectID());
        this.assertFolderNotExistsInFolder(this.trashFolderID, folder.getObjectID());
    }

    public void testDeleteFolderWithConflictingName() throws Exception {
        String foldername = UUID.randomUUID().toString();
        FolderObject folder1 = this.createRandomFolder(this.testFolder.getObjectID(), foldername);
        this.deleteFolder(folder1, null);
        FolderObject folder2 = this.createRandomFolder(this.testFolder.getObjectID(), foldername);
        this.deleteFolder(folder2, null);
        this.assertFolderNotExistsInFolder(this.testFolder.getObjectID(), folder1.getObjectID());
        this.assertFolderNotExistsInFolder(this.testFolder.getObjectID(), folder2.getObjectID());
        this.assertFolderExistsInFolder(this.trashFolderID, folder1.getObjectID());
        this.assertFolderExistsInFolder(this.trashFolderID, folder2.getObjectID());
    }

    public void testHardDeleteFile() throws Exception {
        File file = this.createRandomFile(this.testFolder.getObjectID());
        this.deleteFile(file, Boolean.TRUE);
        this.assertFileNotExistsInFolder(this.testFolder.getObjectID(), file.getId());
        this.assertFileNotExistsInFolder(this.trashFolderID, file.getId());
    }

    public void testSoftDeleteFile() throws Exception {
        File file = this.createRandomFile(this.testFolder.getObjectID());
        this.deleteFile(file, Boolean.FALSE);
        this.assertFileNotExistsInFolder(this.testFolder.getObjectID(), file.getId());
        this.assertFileExistsInFolder(this.trashFolderID, file.getId());
    }

    public void testDefaultDeleteFile() throws Exception {
        File file = this.createRandomFile(this.testFolder.getObjectID());
        this.deleteFile(file, null);
        this.assertFileNotExistsInFolder(this.testFolder.getObjectID(), file.getId());
        this.assertFileExistsInFolder(this.trashFolderID, file.getId());
    }

    public void testDeleteDeletedFile() throws Exception {
        File file = this.createRandomFile(this.testFolder.getObjectID());
        this.deleteFile(file, null);
        this.assertFileNotExistsInFolder(this.testFolder.getObjectID(), file.getId());
        this.assertFileExistsInFolder(this.trashFolderID, file.getId());
        file.setFolderId(String.valueOf(this.client.getValues().getInfostoreTrashFolder()));
        this.deleteFile(file, null);
        this.assertFileNotExistsInFolder(this.testFolder.getObjectID(), file.getId());
        this.assertFileNotExistsInFolder(this.trashFolderID, file.getId());
    }

    public void testDeleteFileWithConflictingName() throws Exception {
        String filename = UUID.randomUUID().toString();
        File file1 = this.createRandomFile(this.testFolder.getObjectID(), filename);
        this.deleteFile(file1, null);
        File file2 = this.createRandomFile(this.testFolder.getObjectID(), filename);
        this.deleteFile(file2, null);
        this.assertFileNotExistsInFolder(this.testFolder.getObjectID(), file1.getId());
        this.assertFileNotExistsInFolder(this.testFolder.getObjectID(), file2.getId());
        this.assertFileExistsInFolder(this.trashFolderID, file1.getId());
        this.assertFileExistsInFolder(this.trashFolderID, file2.getId());
    }

    private void deleteFolder(FolderObject folder, Boolean hardDelete) throws Exception {
        Date timestamp = null != folder.getLastModified() ? folder.getLastModified() : new Date(Long.MAX_VALUE);
        DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), timestamp);
        deleteRequest.setHardDelete(hardDelete);
        CommonDeleteResponse deleteResponse = this.client.execute(deleteRequest);
        JSONArray json = (JSONArray)deleteResponse.getData();
        TrashTest.assertEquals((String)"folder not deleted", (int)0, (int)json.length());
        folder.setLastModified(deleteResponse.getTimestamp());
    }

    private void deleteFile(File file, Boolean hardDelete) throws Exception {
        Date timestamp = null != file.getLastModified() ? file.getLastModified() : new Date(Long.MAX_VALUE);
        DeleteInfostoreRequest deleteRequest = new DeleteInfostoreRequest(file.getId(), file.getFolderId(), timestamp);
        deleteRequest.setHardDelete(hardDelete);
        deleteRequest.setFailOnError(true);
        DeleteInfostoreResponse deleteResponse = this.client.execute(deleteRequest);
        JSONArray json = (JSONArray)deleteResponse.getData();
        TrashTest.assertEquals((String)"file not deleted", (int)0, (int)json.length());
        file.setLastModified(deleteResponse.getTimestamp());
        if (null == hardDelete || Boolean.FALSE.equals(hardDelete)) {
            AllInfostoreRequest allRequest = new AllInfostoreRequest(this.trashFolderID, this.COLUMNS, 1, Order.ASCENDING);
            AbstractColumnsResponse allResponse = this.client.execute(allRequest);
            for (Object[] object : allResponse) {
                if (null == object[1] || !String.valueOf(object[1]).equals(file.getFileName())) continue;
                file.setId(object[0].toString());
                break;
            }
        }
    }

    private void assertFileExistsInFolder(int folderID, String objectID) throws Exception {
        AllInfostoreRequest allRequest = new AllInfostoreRequest(folderID, this.COLUMNS, 1, Order.ASCENDING);
        AbstractColumnsResponse allResponse = this.client.execute(allRequest);
        for (Object[] object : allResponse) {
            String id = object[0].toString();
            if (!objectID.equals(id)) continue;
            return;
        }
        TrashTest.fail((String)("File " + objectID + " not found in folder: " + folderID));
    }

    private void assertFolderExistsInFolder(int folderID, int objectID) throws Exception {
        FolderObject[] folders;
        for (FolderObject folder : folders = this.fMgr.listFoldersOnServer(folderID)) {
            if (folder.getObjectID() != objectID) continue;
            return;
        }
        TrashTest.fail((String)("File " + objectID + " not found in folder: " + folderID));
    }

    private void assertFileNotExistsInFolder(int folderID, String objectID) throws Exception {
        AllInfostoreRequest allRequest = new AllInfostoreRequest(folderID, this.COLUMNS, 1, Order.ASCENDING);
        AbstractColumnsResponse allResponse = this.client.execute(allRequest);
        for (Object[] object : allResponse) {
            String id = object[0].toString();
            TrashTest.assertFalse((String)("File " + objectID + " found in folder: " + folderID), (boolean)objectID.equals(id));
        }
    }

    private void assertFolderNotExistsInFolder(int folderID, int objectID) throws Exception {
        FolderObject[] folders;
        for (FolderObject folder : folders = this.fMgr.listFoldersOnServer(folderID)) {
            TrashTest.assertFalse((String)("Folder " + objectID + " found in folder: " + folderID), (objectID == folder.getObjectID() ? 1 : 0) != 0);
        }
    }

    private FolderObject createRandomFolder(int folderID) throws Exception {
        return this.createRandomFolder(folderID, UUID.randomUUID().toString());
    }

    private FolderObject createRandomFolder(int folderID, String foldername) throws Exception {
        FolderObject folder = this.fMgr.generatePrivateFolder(foldername, 8, folderID, this.client.getValues().getUserId());
        folder = this.fMgr.insertFolderOnServer(folder);
        return folder;
    }

    private File createRandomFile(int folderID) throws Exception {
        return this.createRandomFile(folderID, UUID.randomUUID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createRandomFile(int folderID, String filename) throws Exception {
        DefaultFile file = new DefaultFile();
        file.setFileName(filename);
        file.setFolderId(String.valueOf(folderID));
        file.setCreated(new Date());
        ByteArrayInputStream data = null;
        try {
            data = Streams.newByteArrayInputStream((byte[])UUIDs.toByteArray((UUID)UUID.randomUUID()));
            NewInfostoreResponse newResponse = this.client.execute(new NewInfostoreRequest((File)file, data));
            file.setId(newResponse.getID());
            file.setLastModified(newResponse.getTimestamp());
            this.infoMgr.getCreatedEntities().add((File)file);
        }
        finally {
            Streams.close((Closeable)data);
        }
        return file;
    }
}

