/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.infostore.actions.CheckNameRequest;
import com.openexchange.ajax.infostore.actions.CheckNameResponse;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;

public class CheckNameActionTest
extends AbstractInfostoreTest {
    public CheckNameActionTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidFilename() throws Exception {
        CheckNameRequest req = new CheckNameRequest("thisShouldNotFail", false);
        CheckNameResponse resp = this.client.execute(req);
        CheckNameActionTest.assertFalse((boolean)resp.hasError());
    }

    public void testInvalidCharacter() throws Exception {
        CheckNameRequest req = new CheckNameRequest("withInvalidCharacters<>:/?*\"\\|", false);
        CheckNameResponse resp = this.client.execute(req);
        CheckNameActionTest.assertTrue((boolean)resp.hasError());
        CheckNameActionTest.assertEquals((int)FileStorageExceptionCodes.ILLEGAL_CHARACTERS.getNumber(), (int)resp.getException().getCode());
        OXException e = resp.getException();
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains("<"));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains(">"));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains(":"));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains("/"));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains("?"));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains("*"));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains("\""));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains("\\"));
        CheckNameActionTest.assertTrue((boolean)e.getMessage().contains("|"));
    }

    public void testReservedNames() throws Exception {
        String[] RESERVED_NAMES;
        for (String name : RESERVED_NAMES = new String[]{"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "CON", "NUL", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "AUX", "PRN"}) {
            CheckNameRequest req = new CheckNameRequest(name, false);
            CheckNameResponse resp = this.client.execute(req);
            CheckNameActionTest.assertTrue((boolean)resp.hasError());
            CheckNameActionTest.assertEquals((int)FileStorageExceptionCodes.RESERVED_NAME.getNumber(), (int)resp.getException().getCode());
            CheckNameActionTest.assertTrue((boolean)resp.getErrorMessage().contains(name));
        }
    }

    public void testMatchOnlyExactReservedNames() throws Exception {
        String[] RESERVED_NAMES;
        for (String name : RESERVED_NAMES = new String[]{"COM", "CON1", "NULL", "LPT12", "AUXQWERT", "PRN2"}) {
            CheckNameRequest req = new CheckNameRequest(name, false);
            CheckNameResponse resp = this.client.execute(req);
            CheckNameActionTest.assertFalse((boolean)resp.hasError());
        }
    }

    public void testOnlyDotsInName() throws Exception {
        CheckNameRequest req = new CheckNameRequest("..", false);
        CheckNameResponse resp = this.client.execute(req);
        CheckNameActionTest.assertTrue((boolean)resp.hasError());
        CheckNameActionTest.assertEquals((int)FileStorageExceptionCodes.ONLY_DOTS_NAME.getNumber(), (int)resp.getException().getCode());
        CheckNameActionTest.assertTrue((boolean)resp.getErrorMessage().contains(".."));
    }

    public void testEndsWithWithespace() throws Exception {
        CheckNameRequest req = new CheckNameRequest("willFailToo ", false);
        CheckNameResponse resp = this.client.execute(req);
        CheckNameActionTest.assertTrue((boolean)resp.hasError());
        CheckNameActionTest.assertEquals((int)FileStorageExceptionCodes.WHITESPACE_END.getNumber(), (int)resp.getException().getCode());
        CheckNameActionTest.assertTrue((boolean)resp.getErrorMessage().contains("whitespace"));
    }

    public void testEndsWithDot() throws Exception {
        CheckNameRequest req = new CheckNameRequest("willFailToo.", false);
        CheckNameResponse resp = this.client.execute(req);
        CheckNameActionTest.assertTrue((boolean)resp.hasError());
        CheckNameActionTest.assertEquals((int)FileStorageExceptionCodes.WHITESPACE_END.getNumber(), (int)resp.getException().getCode());
        CheckNameActionTest.assertTrue((boolean)resp.getErrorMessage().contains("whitespace"));
    }
}

