/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.fileaccount.test;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.infostore.fileaccount.actions.AllFileaccountRequest;
import com.openexchange.ajax.infostore.fileaccount.actions.AllFileaccountResponse;
import com.openexchange.ajax.infostore.fileaccount.actions.GetFileaccountRequest;
import com.openexchange.ajax.infostore.fileaccount.actions.GetFileaccountResponse;
import com.openexchange.file.storage.FileStorageCapability;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public final class FilestorageAccountTest
extends AbstractAJAXSession {
    private static final String[] POSSIBLE_CAPABILITIES = new String[]{FileStorageCapability.FILE_VERSIONS.name(), FileStorageCapability.EXTENDED_METADATA.name(), FileStorageCapability.RANDOM_FILE_ACCESS.name(), FileStorageCapability.LOCKS.name()};

    public FilestorageAccountTest(String name) {
        super(name);
    }

    public void testGetFilestorageAccountCapabilities() throws Throwable {
        AJAXClient client = this.getClient();
        GetFileaccountResponse response = client.execute(new GetFileaccountRequest("infostore", "com.openexchange.infostore"));
        FilestorageAccountTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
        Object data = response.getData();
        FilestorageAccountTest.assertNotNull((String)"Response is empty!", (Object)data);
        FilestorageAccountTest.assertTrue((String)"Response contains unexpected data!", (boolean)(data instanceof JSONObject));
        JSONObject account = (JSONObject)data;
        Object caps = account.asMap().get("capabilities");
        FilestorageAccountTest.assertNotNull((String)"Response contains no capabilities field!", caps);
        FilestorageAccountTest.assertTrue((String)"The capabilities field is not a array list!", (boolean)(caps instanceof ArrayList));
        ArrayList capStrings = (ArrayList)caps;
        for (String str : capStrings) {
            boolean contains = false;
            for (String cap : POSSIBLE_CAPABILITIES) {
                if (!cap.equals(str)) continue;
                contains = true;
            }
            FilestorageAccountTest.assertTrue((String)("Returns unknown capability " + str), (boolean)contains);
        }
    }

    public void testGetAllFilestorageAccountCapabilities() throws Throwable {
        AJAXClient client = this.getClient();
        AllFileaccountResponse response = client.execute(new AllFileaccountRequest(null));
        FilestorageAccountTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
        Object data = response.getData();
        FilestorageAccountTest.assertNotNull((String)"Response is empty!", (Object)data);
        FilestorageAccountTest.assertTrue((String)"Response contains unexpected data!", (boolean)(data instanceof JSONArray));
        JSONObject account = ((JSONArray)data).getJSONObject(0);
        Object caps = account.asMap().get("capabilities");
        FilestorageAccountTest.assertNotNull((String)"Response contains no capabilities field!", caps);
        FilestorageAccountTest.assertTrue((String)"The capabilities field is not a array list!", (boolean)(caps instanceof ArrayList));
        ArrayList capStrings = (ArrayList)caps;
        for (String str : capStrings) {
            boolean contains = false;
            for (String cap : POSSIBLE_CAPABILITIES) {
                if (!cap.equals(str)) continue;
                contains = true;
            }
            FilestorageAccountTest.assertTrue((String)("Returns unknown capability " + str), (boolean)contains);
        }
    }
}

