/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreParser;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.file.storage.File;
import com.openexchange.share.notification.ShareNotificationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateInfostoreRequest
extends AbstractInfostoreRequest<UpdateInfostoreResponse> {
    private com.openexchange.file.storage.File metadata;
    private File upload;
    private File.Field[] fields;
    private final String id;
    private final Date lastModified;
    private ShareNotificationService.Transport notificationTransport;
    private String notificationMessage;
    private long offset;

    public UpdateInfostoreRequest(String id, Date lastModified, File upload) {
        this.id = id;
        this.upload = upload;
        this.lastModified = lastModified;
    }

    public UpdateInfostoreRequest(com.openexchange.file.storage.File data, File.Field[] fields, File upload, Date lastModified) {
        this.metadata = data;
        this.id = data.getId();
        this.lastModified = lastModified;
        this.upload = upload;
        this.fields = fields;
    }

    public UpdateInfostoreRequest(com.openexchange.file.storage.File data, File.Field[] fields, Date lastModified) {
        this.metadata = data;
        this.id = data.getId();
        this.lastModified = lastModified;
        this.fields = fields;
    }

    public void setMetadata(com.openexchange.file.storage.File metadata) {
        this.metadata = metadata;
    }

    public void setNotifyPermissionEntities(ShareNotificationService.Transport transport) {
        this.setNotifyPermissionEntities(transport, null);
    }

    public void setNotifyPermissionEntities(ShareNotificationService.Transport transport, String message) {
        this.notificationTransport = transport;
        this.notificationMessage = message;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public com.openexchange.file.storage.File getMetadata() {
        return this.metadata;
    }

    @Override
    public String getBody() throws JSONException {
        JSONObject jFile = this.writeJSON(this.getMetadata(), this.fields);
        if (this.notificationTransport != null) {
            JSONObject data = new JSONObject();
            data.put("file", (Object)jFile);
            JSONObject jNotification = new JSONObject();
            jNotification.put("transport", (Object)this.notificationTransport.getID());
            jNotification.put("message", (Object)this.notificationMessage);
            data.put("notification", (Object)jNotification);
            return data.toString();
        }
        return jFile.toString();
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return null == this.upload ? AJAXRequest.Method.PUT : AJAXRequest.Method.UPLOAD;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> tmp = new ArrayList<AJAXRequest.Parameter>(3);
        tmp.add(new AJAXRequest.Parameter("action", "update"));
        tmp.add(new AJAXRequest.Parameter("id", this.id));
        tmp.add(new AJAXRequest.Parameter("timestamp", this.lastModified));
        if (null != this.upload) {
            tmp.add(new AJAXRequest.FieldParameter("json", this.getBody()));
            tmp.add(new AJAXRequest.FileParameter("file", this.upload.getName(), new FileInputStream(this.upload), this.metadata.getFileMIMEType()));
        }
        if (0L < this.offset) {
            tmp.add(new AJAXRequest.Parameter("offset", String.valueOf(this.offset)));
        }
        return tmp.toArray(new AJAXRequest.Parameter[tmp.size()]);
    }

    public UpdateInfostoreParser getParser() {
        return new UpdateInfostoreParser(this.getFailOnError(), null != this.upload);
    }
}

